package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateCustomGroup invokes the mts.CreateCustomGroup API synchronously
func (client *Client) CreateCustomGroup(request *CreateCustomGroupRequest) (response *CreateCustomGroupResponse, err error) {
	response = CreateCreateCustomGroupResponse()
	err = client.DoAction(request, response)
	return
}

// CreateCustomGroupWithChan invokes the mts.CreateCustomGroup API asynchronously
func (client *Client) CreateCustomGroupWithChan(request *CreateCustomGroupRequest) (<-chan *CreateCustomGroupResponse, <-chan error) {
	responseChan := make(chan *CreateCustomGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateCustomGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateCustomGroupWithCallback invokes the mts.CreateCustomGroup API asynchronously
func (client *Client) CreateCustomGroupWithCallback(request *CreateCustomGroupRequest, callback func(response *CreateCustomGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateCustomGroupResponse
		var err error
		defer close(result)
		response, err = client.CreateCustomGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateCustomGroupRequest is the request struct for api CreateCustomGroup
type CreateCustomGroupRequest struct {
	*requests.RpcRequest
	ResourceOwnerId        requests.Integer `position:"Query" name:"ResourceOwnerId"`
	CustomGroupName        string           `position:"Query" name:"CustomGroupName"`
	Algorithm              string           `position:"Query" name:"Algorithm"`
	ResourceOwnerAccount   string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount           string           `position:"Query" name:"OwnerAccount"`
	OwnerId                requests.Integer `position:"Query" name:"OwnerId"`
	CustomGroupDescription string           `position:"Query" name:"CustomGroupDescription"`
}

// CreateCustomGroupResponse is the response struct for api CreateCustomGroup
type CreateCustomGroupResponse struct {
	*responses.BaseResponse
	CustomGroupId string `json:"CustomGroupId" xml:"CustomGroupId"`
	RequestId     string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateCustomGroupRequest creates a request to invoke CreateCustomGroup API
func CreateCreateCustomGroupRequest() (request *CreateCustomGroupRequest) {
	request = &CreateCustomGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "CreateCustomGroup", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateCustomGroupResponse creates a response to parse from CreateCustomGroup response
func CreateCreateCustomGroupResponse() (response *CreateCustomGroupResponse) {
	response = &CreateCustomGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
