package mseap

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetVariable invokes the mseap.GetVariable API synchronously
func (client *Client) GetVariable(request *GetVariableRequest) (response *GetVariableResponse, err error) {
	response = CreateGetVariableResponse()
	err = client.DoAction(request, response)
	return
}

// GetVariableWithChan invokes the mseap.GetVariable API asynchronously
func (client *Client) GetVariableWithChan(request *GetVariableRequest) (<-chan *GetVariableResponse, <-chan error) {
	responseChan := make(chan *GetVariableResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetVariable(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetVariableWithCallback invokes the mseap.GetVariable API asynchronously
func (client *Client) GetVariableWithCallback(request *GetVariableRequest, callback func(response *GetVariableResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetVariableResponse
		var err error
		defer close(result)
		response, err = client.GetVariable(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetVariableRequest is the request struct for api GetVariable
type GetVariableRequest struct {
	*requests.RpcRequest
	UserCallerParentId          requests.Integer `position:"Query" name:"UserCallerParentId"`
	ApiType                     string           `position:"Query" name:"ApiType"`
	UserMfaPresent              requests.Boolean `position:"Query" name:"UserMfaPresent"`
	UserKp                      string           `position:"Query" name:"UserKp"`
	Lang                        string           `position:"Query" name:"Lang"`
	UserCallerType              string           `position:"Query" name:"UserCallerType"`
	UserSecurityToken           string           `position:"Query" name:"UserSecurityToken"`
	UserAccessKeyId             string           `position:"Query" name:"UserAccessKeyId"`
	AliyunKp                    string           `position:"Query" name:"AliyunKp"`
	UserBid                     string           `position:"Query" name:"UserBid"`
	OriginalRequest             string           `position:"Query" name:"OriginalRequest"`
	TemplateId                  requests.Integer `position:"Query" name:"TemplateId"`
	UserCallerSecurityTransport requests.Boolean `position:"Query" name:"UserCallerSecurityTransport"`
	UserClientIp                string           `position:"Query" name:"UserClientIp"`
	Bid                         string           `position:"Query" name:"Bid"`
}

// GetVariableResponse is the response struct for api GetVariable
type GetVariableResponse struct {
	*responses.BaseResponse
	AllowRetry     bool   `json:"AllowRetry" xml:"AllowRetry"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	ErrorMsg       string `json:"ErrorMsg" xml:"ErrorMsg"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
	Module         string `json:"Module" xml:"Module"`
	Success        bool   `json:"Success" xml:"Success"`
	AppName        string `json:"AppName" xml:"AppName"`
}

// CreateGetVariableRequest creates a request to invoke GetVariable API
func CreateGetVariableRequest() (request *GetVariableRequest) {
	request = &GetVariableRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mseap", "2021-01-18", "GetVariable", "", "")
	request.Method = requests.POST
	return
}

// CreateGetVariableResponse creates a response to parse from GetVariable response
func CreateGetVariableResponse() (response *GetVariableResponse) {
	response = &GetVariableResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
