package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListListenersByIp invokes the mse.ListListenersByIp API synchronously
func (client *Client) ListListenersByIp(request *ListListenersByIpRequest) (response *ListListenersByIpResponse, err error) {
	response = CreateListListenersByIpResponse()
	err = client.DoAction(request, response)
	return
}

// ListListenersByIpWithChan invokes the mse.ListListenersByIp API asynchronously
func (client *Client) ListListenersByIpWithChan(request *ListListenersByIpRequest) (<-chan *ListListenersByIpResponse, <-chan error) {
	responseChan := make(chan *ListListenersByIpResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListListenersByIp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListListenersByIpWithCallback invokes the mse.ListListenersByIp API asynchronously
func (client *Client) ListListenersByIpWithCallback(request *ListListenersByIpRequest, callback func(response *ListListenersByIpResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListListenersByIpResponse
		var err error
		defer close(result)
		response, err = client.ListListenersByIp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListListenersByIpRequest is the request struct for api ListListenersByIp
type ListListenersByIpRequest struct {
	*requests.RpcRequest
	MseSessionId   string `position:"Query" name:"MseSessionId"`
	NamespaceId    string `position:"Query" name:"NamespaceId"`
	RequestPars    string `position:"Query" name:"RequestPars"`
	Ip             string `position:"Query" name:"Ip"`
	InstanceId     string `position:"Query" name:"InstanceId"`
	AcceptLanguage string `position:"Query" name:"AcceptLanguage"`
}

// ListListenersByIpResponse is the response struct for api ListListenersByIp
type ListListenersByIpResponse struct {
	*responses.BaseResponse
	HttpCode   string     `json:"HttpCode" xml:"HttpCode"`
	TotalCount int        `json:"TotalCount" xml:"TotalCount"`
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	Message    string     `json:"Message" xml:"Message"`
	PageSize   int        `json:"PageSize" xml:"PageSize"`
	PageNumber int        `json:"PageNumber" xml:"PageNumber"`
	ErrorCode  string     `json:"ErrorCode" xml:"ErrorCode"`
	Success    bool       `json:"Success" xml:"Success"`
	Listeners  []Listener `json:"Listeners" xml:"Listeners"`
}

// CreateListListenersByIpRequest creates a request to invoke ListListenersByIp API
func CreateListListenersByIpRequest() (request *ListListenersByIpRequest) {
	request = &ListListenersByIpRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "ListListenersByIp", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListListenersByIpResponse creates a response to parse from ListListenersByIp response
func CreateListListenersByIpResponse() (response *ListListenersByIpResponse) {
	response = &ListListenersByIpResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
