package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListGatewayFlowRule invokes the mse.ListGatewayFlowRule API synchronously
func (client *Client) ListGatewayFlowRule(request *ListGatewayFlowRuleRequest) (response *ListGatewayFlowRuleResponse, err error) {
	response = CreateListGatewayFlowRuleResponse()
	err = client.DoAction(request, response)
	return
}

// ListGatewayFlowRuleWithChan invokes the mse.ListGatewayFlowRule API asynchronously
func (client *Client) ListGatewayFlowRuleWithChan(request *ListGatewayFlowRuleRequest) (<-chan *ListGatewayFlowRuleResponse, <-chan error) {
	responseChan := make(chan *ListGatewayFlowRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListGatewayFlowRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListGatewayFlowRuleWithCallback invokes the mse.ListGatewayFlowRule API asynchronously
func (client *Client) ListGatewayFlowRuleWithCallback(request *ListGatewayFlowRuleRequest, callback func(response *ListGatewayFlowRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListGatewayFlowRuleResponse
		var err error
		defer close(result)
		response, err = client.ListGatewayFlowRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListGatewayFlowRuleRequest is the request struct for api ListGatewayFlowRule
type ListGatewayFlowRuleRequest struct {
	*requests.RpcRequest
	MseSessionId   string `position:"Query" name:"MseSessionId"`
	FilterParams   string `position:"Query" name:"FilterParams"`
	AcceptLanguage string `position:"Query" name:"AcceptLanguage"`
}

// ListGatewayFlowRuleResponse is the response struct for api ListGatewayFlowRule
type ListGatewayFlowRuleResponse struct {
	*responses.BaseResponse
	RequestId string                    `json:"RequestId" xml:"RequestId"`
	Data      DataInListGatewayFlowRule `json:"Data" xml:"Data"`
}

// CreateListGatewayFlowRuleRequest creates a request to invoke ListGatewayFlowRule API
func CreateListGatewayFlowRuleRequest() (request *ListGatewayFlowRuleRequest) {
	request = &ListGatewayFlowRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "ListGatewayFlowRule", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListGatewayFlowRuleResponse creates a response to parse from ListGatewayFlowRule response
func CreateListGatewayFlowRuleResponse() (response *ListGatewayFlowRuleResponse) {
	response = &ListGatewayFlowRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
