package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetServiceListeners invokes the mse.GetServiceListeners API synchronously
func (client *Client) GetServiceListeners(request *GetServiceListenersRequest) (response *GetServiceListenersResponse, err error) {
	response = CreateGetServiceListenersResponse()
	err = client.DoAction(request, response)
	return
}

// GetServiceListenersWithChan invokes the mse.GetServiceListeners API asynchronously
func (client *Client) GetServiceListenersWithChan(request *GetServiceListenersRequest) (<-chan *GetServiceListenersResponse, <-chan error) {
	responseChan := make(chan *GetServiceListenersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetServiceListeners(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetServiceListenersWithCallback invokes the mse.GetServiceListeners API asynchronously
func (client *Client) GetServiceListenersWithCallback(request *GetServiceListenersRequest, callback func(response *GetServiceListenersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetServiceListenersResponse
		var err error
		defer close(result)
		response, err = client.GetServiceListeners(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetServiceListenersRequest is the request struct for api GetServiceListeners
type GetServiceListenersRequest struct {
	*requests.RpcRequest
	MseSessionId   string           `position:"Query" name:"MseSessionId"`
	ClusterName    string           `position:"Query" name:"ClusterName"`
	PageNum        requests.Integer `position:"Query" name:"PageNum"`
	NamespaceId    string           `position:"Query" name:"NamespaceId"`
	RequestPars    string           `position:"Query" name:"RequestPars"`
	GroupName      string           `position:"Query" name:"GroupName"`
	InstanceId     string           `position:"Query" name:"InstanceId"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	ServiceName    string           `position:"Query" name:"ServiceName"`
	ClusterId      string           `position:"Query" name:"ClusterId"`
	HasIpCount     string           `position:"Query" name:"HasIpCount"`
	AcceptLanguage string           `position:"Query" name:"AcceptLanguage"`
}

// GetServiceListenersResponse is the response struct for api GetServiceListeners
type GetServiceListenersResponse struct {
	*responses.BaseResponse
	PageNumber int        `json:"PageNumber" xml:"PageNumber"`
	TotalCount int        `json:"TotalCount" xml:"TotalCount"`
	PageSize   int        `json:"PageSize" xml:"PageSize"`
	Success    bool       `json:"Success" xml:"Success"`
	Message    string     `json:"Message" xml:"Message"`
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	ErrorCode  string     `json:"ErrorCode" xml:"ErrorCode"`
	HttpCode   string     `json:"HttpCode" xml:"HttpCode"`
	Data       []DataItem `json:"Data" xml:"Data"`
}

// CreateGetServiceListenersRequest creates a request to invoke GetServiceListeners API
func CreateGetServiceListenersRequest() (request *GetServiceListenersRequest) {
	request = &GetServiceListenersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "GetServiceListeners", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetServiceListenersResponse creates a response to parse from GetServiceListeners response
func CreateGetServiceListenersResponse() (response *GetServiceListenersResponse) {
	response = &GetServiceListenersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
