package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetPlugins invokes the mse.GetPlugins API synchronously
func (client *Client) GetPlugins(request *GetPluginsRequest) (response *GetPluginsResponse, err error) {
	response = CreateGetPluginsResponse()
	err = client.DoAction(request, response)
	return
}

// GetPluginsWithChan invokes the mse.GetPlugins API asynchronously
func (client *Client) GetPluginsWithChan(request *GetPluginsRequest) (<-chan *GetPluginsResponse, <-chan error) {
	responseChan := make(chan *GetPluginsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetPlugins(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetPluginsWithCallback invokes the mse.GetPlugins API asynchronously
func (client *Client) GetPluginsWithCallback(request *GetPluginsRequest, callback func(response *GetPluginsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetPluginsResponse
		var err error
		defer close(result)
		response, err = client.GetPlugins(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetPluginsRequest is the request struct for api GetPlugins
type GetPluginsRequest struct {
	*requests.RpcRequest
	MseSessionId    string           `position:"Query" name:"MseSessionId"`
	GatewayUniqueId string           `position:"Query" name:"GatewayUniqueId"`
	EnableOnly      requests.Boolean `position:"Query" name:"EnableOnly"`
	Name            string           `position:"Query" name:"Name"`
	AcceptLanguage  string           `position:"Query" name:"AcceptLanguage"`
	Category        requests.Integer `position:"Query" name:"Category"`
}

// GetPluginsResponse is the response struct for api GetPlugins
type GetPluginsResponse struct {
	*responses.BaseResponse
	RequestId      string     `json:"RequestId" xml:"RequestId"`
	Success        bool       `json:"Success" xml:"Success"`
	Code           int        `json:"Code" xml:"Code"`
	ErrorCode      string     `json:"ErrorCode" xml:"ErrorCode"`
	HttpStatusCode int        `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string     `json:"Message" xml:"Message"`
	DynamicCode    string     `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage string     `json:"DynamicMessage" xml:"DynamicMessage"`
	Data           []DataItem `json:"Data" xml:"Data"`
}

// CreateGetPluginsRequest creates a request to invoke GetPlugins API
func CreateGetPluginsRequest() (request *GetPluginsRequest) {
	request = &GetPluginsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "GetPlugins", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetPluginsResponse creates a response to parse from GetPlugins response
func CreateGetPluginsResponse() (response *GetPluginsResponse) {
	response = &GetPluginsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
