package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetApplicationList invokes the mse.GetApplicationList API synchronously
func (client *Client) GetApplicationList(request *GetApplicationListRequest) (response *GetApplicationListResponse, err error) {
	response = CreateGetApplicationListResponse()
	err = client.DoAction(request, response)
	return
}

// GetApplicationListWithChan invokes the mse.GetApplicationList API asynchronously
func (client *Client) GetApplicationListWithChan(request *GetApplicationListRequest) (<-chan *GetApplicationListResponse, <-chan error) {
	responseChan := make(chan *GetApplicationListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetApplicationList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetApplicationListWithCallback invokes the mse.GetApplicationList API asynchronously
func (client *Client) GetApplicationListWithCallback(request *GetApplicationListRequest, callback func(response *GetApplicationListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetApplicationListResponse
		var err error
		defer close(result)
		response, err = client.GetApplicationList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetApplicationListRequest is the request struct for api GetApplicationList
type GetApplicationListRequest struct {
	*requests.RpcRequest
	MseSessionId   string           `position:"Query" name:"MseSessionId"`
	Language       string           `position:"Query" name:"Language"`
	Source         string           `position:"Query" name:"Source"`
	PageNumber     requests.Integer `position:"Query" name:"PageNumber"`
	AppName        string           `position:"Query" name:"AppName"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	SwitchEnable   requests.Boolean `position:"Query" name:"SwitchEnable"`
	AppId          string           `position:"Query" name:"AppId"`
	Namespace      string           `position:"Query" name:"Namespace"`
	AcceptLanguage string           `position:"Query" name:"AcceptLanguage"`
	SentinelEnable requests.Boolean `position:"Query" name:"SentinelEnable"`
	Region         string           `position:"Query" name:"Region"`
}

// GetApplicationListResponse is the response struct for api GetApplicationList
type GetApplicationListResponse struct {
	*responses.BaseResponse
	ErrorCode      string                   `json:"ErrorCode" xml:"ErrorCode"`
	Success        bool                     `json:"Success" xml:"Success"`
	HttpStatusCode int                      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string                   `json:"Message" xml:"Message"`
	RequestId      string                   `json:"RequestId" xml:"RequestId"`
	Code           int                      `json:"Code" xml:"Code"`
	Data           DataInGetApplicationList `json:"Data" xml:"Data"`
}

// CreateGetApplicationListRequest creates a request to invoke GetApplicationList API
func CreateGetApplicationListRequest() (request *GetApplicationListRequest) {
	request = &GetApplicationListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "GetApplicationList", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetApplicationListResponse creates a response to parse from GetApplicationList response
func CreateGetApplicationListResponse() (response *GetApplicationListResponse) {
	response = &GetApplicationListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
