package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteGatewayAuthConsumer invokes the mse.DeleteGatewayAuthConsumer API synchronously
func (client *Client) DeleteGatewayAuthConsumer(request *DeleteGatewayAuthConsumerRequest) (response *DeleteGatewayAuthConsumerResponse, err error) {
	response = CreateDeleteGatewayAuthConsumerResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteGatewayAuthConsumerWithChan invokes the mse.DeleteGatewayAuthConsumer API asynchronously
func (client *Client) DeleteGatewayAuthConsumerWithChan(request *DeleteGatewayAuthConsumerRequest) (<-chan *DeleteGatewayAuthConsumerResponse, <-chan error) {
	responseChan := make(chan *DeleteGatewayAuthConsumerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteGatewayAuthConsumer(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteGatewayAuthConsumerWithCallback invokes the mse.DeleteGatewayAuthConsumer API asynchronously
func (client *Client) DeleteGatewayAuthConsumerWithCallback(request *DeleteGatewayAuthConsumerRequest, callback func(response *DeleteGatewayAuthConsumerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteGatewayAuthConsumerResponse
		var err error
		defer close(result)
		response, err = client.DeleteGatewayAuthConsumer(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteGatewayAuthConsumerRequest is the request struct for api DeleteGatewayAuthConsumer
type DeleteGatewayAuthConsumerRequest struct {
	*requests.RpcRequest
	MseSessionId    string           `position:"Query" name:"MseSessionId"`
	GatewayUniqueId string           `position:"Query" name:"GatewayUniqueId"`
	Id              requests.Integer `position:"Query" name:"Id"`
	AcceptLanguage  string           `position:"Query" name:"AcceptLanguage"`
}

// DeleteGatewayAuthConsumerResponse is the response struct for api DeleteGatewayAuthConsumer
type DeleteGatewayAuthConsumerResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           int    `json:"Code" xml:"Code"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
	Data           bool   `json:"Data" xml:"Data"`
}

// CreateDeleteGatewayAuthConsumerRequest creates a request to invoke DeleteGatewayAuthConsumer API
func CreateDeleteGatewayAuthConsumerRequest() (request *DeleteGatewayAuthConsumerRequest) {
	request = &DeleteGatewayAuthConsumerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "DeleteGatewayAuthConsumer", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteGatewayAuthConsumerResponse creates a response to parse from DeleteGatewayAuthConsumer response
func CreateDeleteGatewayAuthConsumerResponse() (response *DeleteGatewayAuthConsumerResponse) {
	response = &DeleteGatewayAuthConsumerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
