package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateGatewayFlowRule invokes the mse.CreateGatewayFlowRule API synchronously
func (client *Client) CreateGatewayFlowRule(request *CreateGatewayFlowRuleRequest) (response *CreateGatewayFlowRuleResponse, err error) {
	response = CreateCreateGatewayFlowRuleResponse()
	err = client.DoAction(request, response)
	return
}

// CreateGatewayFlowRuleWithChan invokes the mse.CreateGatewayFlowRule API asynchronously
func (client *Client) CreateGatewayFlowRuleWithChan(request *CreateGatewayFlowRuleRequest) (<-chan *CreateGatewayFlowRuleResponse, <-chan error) {
	responseChan := make(chan *CreateGatewayFlowRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateGatewayFlowRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateGatewayFlowRuleWithCallback invokes the mse.CreateGatewayFlowRule API asynchronously
func (client *Client) CreateGatewayFlowRuleWithCallback(request *CreateGatewayFlowRuleRequest, callback func(response *CreateGatewayFlowRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateGatewayFlowRuleResponse
		var err error
		defer close(result)
		response, err = client.CreateGatewayFlowRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateGatewayFlowRuleRequest is the request struct for api CreateGatewayFlowRule
type CreateGatewayFlowRuleRequest struct {
	*requests.RpcRequest
	MseSessionId        string           `position:"Query" name:"MseSessionId"`
	Threshold           requests.Integer `position:"Query" name:"Threshold"`
	BehaviorType        requests.Integer `position:"Query" name:"BehaviorType"`
	Enable              requests.Integer `position:"Query" name:"Enable"`
	GatewayId           requests.Integer `position:"Query" name:"GatewayId"`
	ResponseStatusCode  requests.Integer `position:"Query" name:"ResponseStatusCode"`
	RouteId             requests.Integer `position:"Query" name:"RouteId"`
	GatewayUniqueId     string           `position:"Query" name:"GatewayUniqueId"`
	BodyEncoding        requests.Integer `position:"Query" name:"BodyEncoding"`
	ResponseRedirectUrl string           `position:"Query" name:"ResponseRedirectUrl"`
	RouteName           string           `position:"Query" name:"RouteName"`
	AcceptLanguage      string           `position:"Query" name:"AcceptLanguage"`
	ResponseContentBody string           `position:"Query" name:"ResponseContentBody"`
}

// CreateGatewayFlowRuleResponse is the response struct for api CreateGatewayFlowRule
type CreateGatewayFlowRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      int64  `json:"Data" xml:"Data"`
}

// CreateCreateGatewayFlowRuleRequest creates a request to invoke CreateGatewayFlowRule API
func CreateCreateGatewayFlowRuleRequest() (request *CreateGatewayFlowRuleRequest) {
	request = &CreateGatewayFlowRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "CreateGatewayFlowRule", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateGatewayFlowRuleResponse creates a response to parse from CreateGatewayFlowRule response
func CreateCreateGatewayFlowRuleResponse() (response *CreateGatewayFlowRuleResponse) {
	response = &CreateGatewayFlowRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
