package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListMcubeMiniApps invokes the mpaas.ListMcubeMiniApps API synchronously
func (client *Client) ListMcubeMiniApps(request *ListMcubeMiniAppsRequest) (response *ListMcubeMiniAppsResponse, err error) {
	response = CreateListMcubeMiniAppsResponse()
	err = client.DoAction(request, response)
	return
}

// ListMcubeMiniAppsWithChan invokes the mpaas.ListMcubeMiniApps API asynchronously
func (client *Client) ListMcubeMiniAppsWithChan(request *ListMcubeMiniAppsRequest) (<-chan *ListMcubeMiniAppsResponse, <-chan error) {
	responseChan := make(chan *ListMcubeMiniAppsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListMcubeMiniApps(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListMcubeMiniAppsWithCallback invokes the mpaas.ListMcubeMiniApps API asynchronously
func (client *Client) ListMcubeMiniAppsWithCallback(request *ListMcubeMiniAppsRequest, callback func(response *ListMcubeMiniAppsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListMcubeMiniAppsResponse
		var err error
		defer close(result)
		response, err = client.ListMcubeMiniApps(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListMcubeMiniAppsRequest is the request struct for api ListMcubeMiniApps
type ListMcubeMiniAppsRequest struct {
	*requests.RpcRequest
	TenantId    string `position:"Body" name:"TenantId"`
	AppId       string `position:"Body" name:"AppId"`
	WorkspaceId string `position:"Body" name:"WorkspaceId"`
}

// ListMcubeMiniAppsResponse is the response struct for api ListMcubeMiniApps
type ListMcubeMiniAppsResponse struct {
	*responses.BaseResponse
	ResultMessage  string         `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode     string         `json:"ResultCode" xml:"ResultCode"`
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	ListMiniResult ListMiniResult `json:"ListMiniResult" xml:"ListMiniResult"`
}

// CreateListMcubeMiniAppsRequest creates a request to invoke ListMcubeMiniApps API
func CreateListMcubeMiniAppsRequest() (request *ListMcubeMiniAppsRequest) {
	request = &ListMcubeMiniAppsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "ListMcubeMiniApps", "", "")
	request.Method = requests.POST
	return
}

// CreateListMcubeMiniAppsResponse creates a response to parse from ListMcubeMiniApps response
func CreateListMcubeMiniAppsResponse() (response *ListMcubeMiniAppsResponse) {
	response = &ListMcubeMiniAppsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
