package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMsacTinyAppInfo invokes the mpaas.GetMsacTinyAppInfo API synchronously
func (client *Client) GetMsacTinyAppInfo(request *GetMsacTinyAppInfoRequest) (response *GetMsacTinyAppInfoResponse, err error) {
	response = CreateGetMsacTinyAppInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetMsacTinyAppInfoWithChan invokes the mpaas.GetMsacTinyAppInfo API asynchronously
func (client *Client) GetMsacTinyAppInfoWithChan(request *GetMsacTinyAppInfoRequest) (<-chan *GetMsacTinyAppInfoResponse, <-chan error) {
	responseChan := make(chan *GetMsacTinyAppInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMsacTinyAppInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMsacTinyAppInfoWithCallback invokes the mpaas.GetMsacTinyAppInfo API asynchronously
func (client *Client) GetMsacTinyAppInfoWithCallback(request *GetMsacTinyAppInfoRequest, callback func(response *GetMsacTinyAppInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMsacTinyAppInfoResponse
		var err error
		defer close(result)
		response, err = client.GetMsacTinyAppInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMsacTinyAppInfoRequest is the request struct for api GetMsacTinyAppInfo
type GetMsacTinyAppInfoRequest struct {
	*requests.RpcRequest
	Type        requests.Integer `position:"Body" name:"Type"`
	TenantId    string           `position:"Body" name:"TenantId"`
	AppId       string           `position:"Body" name:"AppId"`
	WorkspaceId string           `position:"Body" name:"WorkspaceId"`
}

// GetMsacTinyAppInfoResponse is the response struct for api GetMsacTinyAppInfo
type GetMsacTinyAppInfoResponse struct {
	*responses.BaseResponse
	ResultMessage string                            `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode    string                            `json:"ResultCode" xml:"ResultCode"`
	RequestId     string                            `json:"RequestId" xml:"RequestId"`
	ResultContent ResultContentInGetMsacTinyAppInfo `json:"ResultContent" xml:"ResultContent"`
}

// CreateGetMsacTinyAppInfoRequest creates a request to invoke GetMsacTinyAppInfo API
func CreateGetMsacTinyAppInfoRequest() (request *GetMsacTinyAppInfoRequest) {
	request = &GetMsacTinyAppInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "GetMsacTinyAppInfo", "", "")
	request.Method = requests.POST
	return
}

// CreateGetMsacTinyAppInfoResponse creates a response to parse from GetMsacTinyAppInfo response
func CreateGetMsacTinyAppInfoResponse() (response *GetMsacTinyAppInfoResponse) {
	response = &GetMsacTinyAppInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
