package market

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeProducts invokes the market.DescribeProducts API synchronously
func (client *Client) DescribeProducts(request *DescribeProductsRequest) (response *DescribeProductsResponse, err error) {
	response = CreateDescribeProductsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeProductsWithChan invokes the market.DescribeProducts API asynchronously
func (client *Client) DescribeProductsWithChan(request *DescribeProductsRequest) (<-chan *DescribeProductsResponse, <-chan error) {
	responseChan := make(chan *DescribeProductsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeProducts(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeProductsWithCallback invokes the market.DescribeProducts API asynchronously
func (client *Client) DescribeProductsWithCallback(request *DescribeProductsRequest, callback func(response *DescribeProductsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeProductsResponse
		var err error
		defer close(result)
		response, err = client.DescribeProducts(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeProductsRequest is the request struct for api DescribeProducts
type DescribeProductsRequest struct {
	*requests.RpcRequest
	SearchTerm string                    `position:"Query" name:"SearchTerm"`
	PageNumber requests.Integer          `position:"Query" name:"PageNumber"`
	Filter     *[]DescribeProductsFilter `position:"Query" name:"Filter"  type:"Repeated"`
	PageSize   requests.Integer          `position:"Query" name:"PageSize"`
}

// DescribeProductsFilter is a repeated param struct in DescribeProductsRequest
type DescribeProductsFilter struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// DescribeProductsResponse is the response struct for api DescribeProducts
type DescribeProductsResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	PageNumber   int          `json:"PageNumber" xml:"PageNumber"`
	PageSize     int          `json:"PageSize" xml:"PageSize"`
	TotalCount   int          `json:"TotalCount" xml:"TotalCount"`
	ProductItems ProductItems `json:"ProductItems" xml:"ProductItems"`
}

// CreateDescribeProductsRequest creates a request to invoke DescribeProducts API
func CreateDescribeProductsRequest() (request *DescribeProductsRequest) {
	request = &DescribeProductsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Market", "2015-11-01", "DescribeProducts", "yunmarket", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeProductsResponse creates a response to parse from DescribeProducts response
func CreateDescribeProductsResponse() (response *DescribeProductsResponse) {
	response = &DescribeProductsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
