package market

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeOrder invokes the market.DescribeOrder API synchronously
func (client *Client) DescribeOrder(request *DescribeOrderRequest) (response *DescribeOrderResponse, err error) {
	response = CreateDescribeOrderResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeOrderWithChan invokes the market.DescribeOrder API asynchronously
func (client *Client) DescribeOrderWithChan(request *DescribeOrderRequest) (<-chan *DescribeOrderResponse, <-chan error) {
	responseChan := make(chan *DescribeOrderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeOrder(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeOrderWithCallback invokes the market.DescribeOrder API asynchronously
func (client *Client) DescribeOrderWithCallback(request *DescribeOrderRequest, callback func(response *DescribeOrderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeOrderResponse
		var err error
		defer close(result)
		response, err = client.DescribeOrder(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeOrderRequest is the request struct for api DescribeOrder
type DescribeOrderRequest struct {
	*requests.RpcRequest
	OrderId string `position:"Query" name:"OrderId"`
}

// DescribeOrderResponse is the response struct for api DescribeOrder
type DescribeOrderResponse struct {
	*responses.BaseResponse
	ProductName         string                     `json:"ProductName" xml:"ProductName"`
	SupplierCompanyName string                     `json:"SupplierCompanyName" xml:"SupplierCompanyName"`
	OriginalPrice       float64                    `json:"OriginalPrice" xml:"OriginalPrice"`
	AliUid              int64                      `json:"AliUid" xml:"AliUid"`
	CouponPrice         float64                    `json:"CouponPrice" xml:"CouponPrice"`
	AccountQuantity     int64                      `json:"AccountQuantity" xml:"AccountQuantity"`
	PeriodType          string                     `json:"PeriodType" xml:"PeriodType"`
	RequestId           string                     `json:"RequestId" xml:"RequestId"`
	PayStatus           string                     `json:"PayStatus" xml:"PayStatus"`
	PaymentPrice        float64                    `json:"PaymentPrice" xml:"PaymentPrice"`
	OrderStatus         string                     `json:"OrderStatus" xml:"OrderStatus"`
	ProductSkuCode      string                     `json:"ProductSkuCode" xml:"ProductSkuCode"`
	PaidOn              int64                      `json:"PaidOn" xml:"PaidOn"`
	Components          map[string]interface{}     `json:"Components" xml:"Components"`
	CreatedOn           int64                      `json:"CreatedOn" xml:"CreatedOn"`
	OrderType           string                     `json:"OrderType" xml:"OrderType"`
	TotalPrice          float64                    `json:"TotalPrice" xml:"TotalPrice"`
	Quantity            int                        `json:"Quantity" xml:"Quantity"`
	OrderId             int64                      `json:"OrderId" xml:"OrderId"`
	ProductCode         string                     `json:"ProductCode" xml:"ProductCode"`
	SupplierTelephones  SupplierTelephones         `json:"SupplierTelephones" xml:"SupplierTelephones"`
	InstanceIds         InstanceIdsInDescribeOrder `json:"InstanceIds" xml:"InstanceIds"`
}

// CreateDescribeOrderRequest creates a request to invoke DescribeOrder API
func CreateDescribeOrderRequest() (request *DescribeOrderRequest) {
	request = &DescribeOrderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Market", "2015-11-01", "DescribeOrder", "yunmarket", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeOrderResponse creates a response to parse from DescribeOrder response
func CreateDescribeOrderResponse() (response *DescribeOrderResponse) {
	response = &DescribeOrderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
