package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListBaaSFabricConsortium invokes the lto.ListBaaSFabricConsortium API synchronously
func (client *Client) ListBaaSFabricConsortium(request *ListBaaSFabricConsortiumRequest) (response *ListBaaSFabricConsortiumResponse, err error) {
	response = CreateListBaaSFabricConsortiumResponse()
	err = client.DoAction(request, response)
	return
}

// ListBaaSFabricConsortiumWithChan invokes the lto.ListBaaSFabricConsortium API asynchronously
func (client *Client) ListBaaSFabricConsortiumWithChan(request *ListBaaSFabricConsortiumRequest) (<-chan *ListBaaSFabricConsortiumResponse, <-chan error) {
	responseChan := make(chan *ListBaaSFabricConsortiumResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListBaaSFabricConsortium(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListBaaSFabricConsortiumWithCallback invokes the lto.ListBaaSFabricConsortium API asynchronously
func (client *Client) ListBaaSFabricConsortiumWithCallback(request *ListBaaSFabricConsortiumRequest, callback func(response *ListBaaSFabricConsortiumResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListBaaSFabricConsortiumResponse
		var err error
		defer close(result)
		response, err = client.ListBaaSFabricConsortium(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListBaaSFabricConsortiumRequest is the request struct for api ListBaaSFabricConsortium
type ListBaaSFabricConsortiumRequest struct {
	*requests.RpcRequest
}

// ListBaaSFabricConsortiumResponse is the response struct for api ListBaaSFabricConsortium
type ListBaaSFabricConsortiumResponse struct {
	*responses.BaseResponse
	Code           string                     `json:"Code" xml:"Code"`
	HttpStatusCode int                        `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string                     `json:"Message" xml:"Message"`
	RequestId      string                     `json:"RequestId" xml:"RequestId"`
	Success        bool                       `json:"Success" xml:"Success"`
	Data           []BaaSFabricConsortiumInfo `json:"Data" xml:"Data"`
}

// CreateListBaaSFabricConsortiumRequest creates a request to invoke ListBaaSFabricConsortium API
func CreateListBaaSFabricConsortiumRequest() (request *ListBaaSFabricConsortiumRequest) {
	request = &ListBaaSFabricConsortiumRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "ListBaaSFabricConsortium", "", "")
	request.Method = requests.POST
	return
}

// CreateListBaaSFabricConsortiumResponse creates a response to parse from ListBaaSFabricConsortium response
func CreateListBaaSFabricConsortiumResponse() (response *ListBaaSFabricConsortiumResponse) {
	response = &ListBaaSFabricConsortiumResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
