package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeMemberTotalStatInfo invokes the lto.DescribeMemberTotalStatInfo API synchronously
func (client *Client) DescribeMemberTotalStatInfo(request *DescribeMemberTotalStatInfoRequest) (response *DescribeMemberTotalStatInfoResponse, err error) {
	response = CreateDescribeMemberTotalStatInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeMemberTotalStatInfoWithChan invokes the lto.DescribeMemberTotalStatInfo API asynchronously
func (client *Client) DescribeMemberTotalStatInfoWithChan(request *DescribeMemberTotalStatInfoRequest) (<-chan *DescribeMemberTotalStatInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeMemberTotalStatInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeMemberTotalStatInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeMemberTotalStatInfoWithCallback invokes the lto.DescribeMemberTotalStatInfo API asynchronously
func (client *Client) DescribeMemberTotalStatInfoWithCallback(request *DescribeMemberTotalStatInfoRequest, callback func(response *DescribeMemberTotalStatInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeMemberTotalStatInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeMemberTotalStatInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeMemberTotalStatInfoRequest is the request struct for api DescribeMemberTotalStatInfo
type DescribeMemberTotalStatInfoRequest struct {
	*requests.RpcRequest
	AccountId string `position:"Query" name:"AccountId"`
}

// DescribeMemberTotalStatInfoResponse is the response struct for api DescribeMemberTotalStatInfo
type DescribeMemberTotalStatInfoResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateDescribeMemberTotalStatInfoRequest creates a request to invoke DescribeMemberTotalStatInfo API
func CreateDescribeMemberTotalStatInfoRequest() (request *DescribeMemberTotalStatInfoRequest) {
	request = &DescribeMemberTotalStatInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "DescribeMemberTotalStatInfo", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeMemberTotalStatInfoResponse creates a response to parse from DescribeMemberTotalStatInfo response
func CreateDescribeMemberTotalStatInfoResponse() (response *DescribeMemberTotalStatInfoResponse) {
	response = &DescribeMemberTotalStatInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
