package ltl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListMPCoSPhaseGroup invokes the ltl.ListMPCoSPhaseGroup API synchronously
func (client *Client) ListMPCoSPhaseGroup(request *ListMPCoSPhaseGroupRequest) (response *ListMPCoSPhaseGroupResponse, err error) {
	response = CreateListMPCoSPhaseGroupResponse()
	err = client.DoAction(request, response)
	return
}

// ListMPCoSPhaseGroupWithChan invokes the ltl.ListMPCoSPhaseGroup API asynchronously
func (client *Client) ListMPCoSPhaseGroupWithChan(request *ListMPCoSPhaseGroupRequest) (<-chan *ListMPCoSPhaseGroupResponse, <-chan error) {
	responseChan := make(chan *ListMPCoSPhaseGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListMPCoSPhaseGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListMPCoSPhaseGroupWithCallback invokes the ltl.ListMPCoSPhaseGroup API asynchronously
func (client *Client) ListMPCoSPhaseGroupWithCallback(request *ListMPCoSPhaseGroupRequest, callback func(response *ListMPCoSPhaseGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListMPCoSPhaseGroupResponse
		var err error
		defer close(result)
		response, err = client.ListMPCoSPhaseGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListMPCoSPhaseGroupRequest is the request struct for api ListMPCoSPhaseGroup
type ListMPCoSPhaseGroupRequest struct {
	*requests.RpcRequest
	Size       requests.Integer `position:"Query" name:"Size"`
	Num        requests.Integer `position:"Query" name:"Num"`
	Name       string           `position:"Query" name:"Name"`
	ApiVersion string           `position:"Query" name:"ApiVersion"`
	BizChainId string           `position:"Query" name:"BizChainId"`
}

// ListMPCoSPhaseGroupResponse is the response struct for api ListMPCoSPhaseGroup
type ListMPCoSPhaseGroupResponse struct {
	*responses.BaseResponse
	Code      int                       `json:"Code" xml:"Code"`
	Message   string                    `json:"Message" xml:"Message"`
	RequestId string                    `json:"RequestId" xml:"RequestId"`
	Success   bool                      `json:"Success" xml:"Success"`
	Data      DataInListMPCoSPhaseGroup `json:"Data" xml:"Data"`
}

// CreateListMPCoSPhaseGroupRequest creates a request to invoke ListMPCoSPhaseGroup API
func CreateListMPCoSPhaseGroupRequest() (request *ListMPCoSPhaseGroupRequest) {
	request = &ListMPCoSPhaseGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ltl", "2019-05-10", "ListMPCoSPhaseGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateListMPCoSPhaseGroupResponse creates a response to parse from ListMPCoSPhaseGroup response
func CreateListMPCoSPhaseGroupResponse() (response *ListMPCoSPhaseGroupResponse) {
	response = &ListMPCoSPhaseGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
