package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateLivePackageConfig invokes the live.UpdateLivePackageConfig API synchronously
func (client *Client) UpdateLivePackageConfig(request *UpdateLivePackageConfigRequest) (response *UpdateLivePackageConfigResponse, err error) {
	response = CreateUpdateLivePackageConfigResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateLivePackageConfigWithChan invokes the live.UpdateLivePackageConfig API asynchronously
func (client *Client) UpdateLivePackageConfigWithChan(request *UpdateLivePackageConfigRequest) (<-chan *UpdateLivePackageConfigResponse, <-chan error) {
	responseChan := make(chan *UpdateLivePackageConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateLivePackageConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateLivePackageConfigWithCallback invokes the live.UpdateLivePackageConfig API asynchronously
func (client *Client) UpdateLivePackageConfigWithCallback(request *UpdateLivePackageConfigRequest, callback func(response *UpdateLivePackageConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateLivePackageConfigResponse
		var err error
		defer close(result)
		response, err = client.UpdateLivePackageConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateLivePackageConfigRequest is the request struct for api UpdateLivePackageConfig
type UpdateLivePackageConfigRequest struct {
	*requests.RpcRequest
	SegmentNum      requests.Integer `position:"Query" name:"SegmentNum"`
	Protocol        string           `position:"Query" name:"Protocol"`
	AppName         string           `position:"Query" name:"AppName"`
	PartDuration    requests.Integer `position:"Query" name:"PartDuration"`
	StreamName      string           `position:"Query" name:"StreamName"`
	IgnoreTranscode requests.Boolean `position:"Query" name:"IgnoreTranscode"`
	DomainName      string           `position:"Query" name:"DomainName"`
	OwnerId         requests.Integer `position:"Query" name:"OwnerId"`
	SegmentDuration requests.Integer `position:"Query" name:"SegmentDuration"`
}

// UpdateLivePackageConfigResponse is the response struct for api UpdateLivePackageConfig
type UpdateLivePackageConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateLivePackageConfigRequest creates a request to invoke UpdateLivePackageConfig API
func CreateUpdateLivePackageConfigRequest() (request *UpdateLivePackageConfigRequest) {
	request = &UpdateLivePackageConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "UpdateLivePackageConfig", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateLivePackageConfigResponse creates a response to parse from UpdateLivePackageConfig response
func CreateUpdateLivePackageConfigResponse() (response *UpdateLivePackageConfigResponse) {
	response = &UpdateLivePackageConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
