package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateEdgeTranscodeJob invokes the live.UpdateEdgeTranscodeJob API synchronously
func (client *Client) UpdateEdgeTranscodeJob(request *UpdateEdgeTranscodeJobRequest) (response *UpdateEdgeTranscodeJobResponse, err error) {
	response = CreateUpdateEdgeTranscodeJobResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateEdgeTranscodeJobWithChan invokes the live.UpdateEdgeTranscodeJob API asynchronously
func (client *Client) UpdateEdgeTranscodeJobWithChan(request *UpdateEdgeTranscodeJobRequest) (<-chan *UpdateEdgeTranscodeJobResponse, <-chan error) {
	responseChan := make(chan *UpdateEdgeTranscodeJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateEdgeTranscodeJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateEdgeTranscodeJobWithCallback invokes the live.UpdateEdgeTranscodeJob API asynchronously
func (client *Client) UpdateEdgeTranscodeJobWithCallback(request *UpdateEdgeTranscodeJobRequest, callback func(response *UpdateEdgeTranscodeJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateEdgeTranscodeJobResponse
		var err error
		defer close(result)
		response, err = client.UpdateEdgeTranscodeJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateEdgeTranscodeJobRequest is the request struct for api UpdateEdgeTranscodeJob
type UpdateEdgeTranscodeJobRequest struct {
	*requests.RpcRequest
	StreamInput  string           `position:"Query" name:"StreamInput"`
	StreamOutput string           `position:"Query" name:"StreamOutput"`
	JobId        string           `position:"Query" name:"JobId"`
	ClusterId    string           `position:"Query" name:"ClusterId"`
	OwnerId      requests.Integer `position:"Query" name:"OwnerId"`
	TemplateId   string           `position:"Query" name:"TemplateId"`
	Name         string           `position:"Query" name:"Name"`
}

// UpdateEdgeTranscodeJobResponse is the response struct for api UpdateEdgeTranscodeJob
type UpdateEdgeTranscodeJobResponse struct {
	*responses.BaseResponse
	JobId     string `json:"JobId" xml:"JobId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateEdgeTranscodeJobRequest creates a request to invoke UpdateEdgeTranscodeJob API
func CreateUpdateEdgeTranscodeJobRequest() (request *UpdateEdgeTranscodeJobRequest) {
	request = &UpdateEdgeTranscodeJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "UpdateEdgeTranscodeJob", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateEdgeTranscodeJobResponse creates a response to parse from UpdateEdgeTranscodeJob response
func CreateUpdateEdgeTranscodeJobResponse() (response *UpdateEdgeTranscodeJobResponse) {
	response = &UpdateEdgeTranscodeJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
