package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StopLiveMPUTask invokes the live.StopLiveMPUTask API synchronously
func (client *Client) StopLiveMPUTask(request *StopLiveMPUTaskRequest) (response *StopLiveMPUTaskResponse, err error) {
	response = CreateStopLiveMPUTaskResponse()
	err = client.DoAction(request, response)
	return
}

// StopLiveMPUTaskWithChan invokes the live.StopLiveMPUTask API asynchronously
func (client *Client) StopLiveMPUTaskWithChan(request *StopLiveMPUTaskRequest) (<-chan *StopLiveMPUTaskResponse, <-chan error) {
	responseChan := make(chan *StopLiveMPUTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StopLiveMPUTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StopLiveMPUTaskWithCallback invokes the live.StopLiveMPUTask API asynchronously
func (client *Client) StopLiveMPUTaskWithCallback(request *StopLiveMPUTaskRequest, callback func(response *StopLiveMPUTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StopLiveMPUTaskResponse
		var err error
		defer close(result)
		response, err = client.StopLiveMPUTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StopLiveMPUTaskRequest is the request struct for api StopLiveMPUTask
type StopLiveMPUTaskRequest struct {
	*requests.RpcRequest
	AppId  string `position:"Query" name:"AppId"`
	TaskId string `position:"Query" name:"TaskId"`
}

// StopLiveMPUTaskResponse is the response struct for api StopLiveMPUTask
type StopLiveMPUTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateStopLiveMPUTaskRequest creates a request to invoke StopLiveMPUTask API
func CreateStopLiveMPUTaskRequest() (request *StopLiveMPUTaskRequest) {
	request = &StopLiveMPUTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "StopLiveMPUTask", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStopLiveMPUTaskResponse creates a response to parse from StopLiveMPUTask response
func CreateStopLiveMPUTaskResponse() (response *StopLiveMPUTaskResponse) {
	response = &StopLiveMPUTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
