package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetShowListBackground invokes the live.SetShowListBackground API synchronously
func (client *Client) SetShowListBackground(request *SetShowListBackgroundRequest) (response *SetShowListBackgroundResponse, err error) {
	response = CreateSetShowListBackgroundResponse()
	err = client.DoAction(request, response)
	return
}

// SetShowListBackgroundWithChan invokes the live.SetShowListBackground API asynchronously
func (client *Client) SetShowListBackgroundWithChan(request *SetShowListBackgroundRequest) (<-chan *SetShowListBackgroundResponse, <-chan error) {
	responseChan := make(chan *SetShowListBackgroundResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetShowListBackground(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetShowListBackgroundWithCallback invokes the live.SetShowListBackground API asynchronously
func (client *Client) SetShowListBackgroundWithCallback(request *SetShowListBackgroundRequest, callback func(response *SetShowListBackgroundResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetShowListBackgroundResponse
		var err error
		defer close(result)
		response, err = client.SetShowListBackground(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetShowListBackgroundRequest is the request struct for api SetShowListBackground
type SetShowListBackgroundRequest struct {
	*requests.RpcRequest
	MaterialId   string           `position:"Query" name:"MaterialId"`
	CasterId     string           `position:"Query" name:"CasterId"`
	OwnerId      requests.Integer `position:"Query" name:"OwnerId"`
	ResourceType string           `position:"Query" name:"ResourceType"`
	ResourceUrl  string           `position:"Query" name:"ResourceUrl"`
}

// SetShowListBackgroundResponse is the response struct for api SetShowListBackground
type SetShowListBackgroundResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetShowListBackgroundRequest creates a request to invoke SetShowListBackground API
func CreateSetShowListBackgroundRequest() (request *SetShowListBackgroundRequest) {
	request = &SetShowListBackgroundRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "SetShowListBackground", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSetShowListBackgroundResponse creates a response to parse from SetShowListBackground response
func CreateSetShowListBackgroundResponse() (response *SetShowListBackgroundResponse) {
	response = &SetShowListBackgroundResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
