package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListLiveMessageApps invokes the live.ListLiveMessageApps API synchronously
func (client *Client) ListLiveMessageApps(request *ListLiveMessageAppsRequest) (response *ListLiveMessageAppsResponse, err error) {
	response = CreateListLiveMessageAppsResponse()
	err = client.DoAction(request, response)
	return
}

// ListLiveMessageAppsWithChan invokes the live.ListLiveMessageApps API asynchronously
func (client *Client) ListLiveMessageAppsWithChan(request *ListLiveMessageAppsRequest) (<-chan *ListLiveMessageAppsResponse, <-chan error) {
	responseChan := make(chan *ListLiveMessageAppsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListLiveMessageApps(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListLiveMessageAppsWithCallback invokes the live.ListLiveMessageApps API asynchronously
func (client *Client) ListLiveMessageAppsWithCallback(request *ListLiveMessageAppsRequest, callback func(response *ListLiveMessageAppsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListLiveMessageAppsResponse
		var err error
		defer close(result)
		response, err = client.ListLiveMessageApps(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListLiveMessageAppsRequest is the request struct for api ListLiveMessageApps
type ListLiveMessageAppsRequest struct {
	*requests.RpcRequest
	SortType      requests.Integer `position:"Query" name:"SortType"`
	NextPageToken requests.Integer `position:"Query" name:"NextPageToken"`
	DataCenter    string           `position:"Query" name:"DataCenter"`
}

// ListLiveMessageAppsResponse is the response struct for api ListLiveMessageApps
type ListLiveMessageAppsResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	HasMore       bool   `json:"HasMore" xml:"HasMore"`
	NextPageToken int64  `json:"NextPageToken" xml:"NextPageToken"`
	AppList       []Apps `json:"AppList" xml:"AppList"`
}

// CreateListLiveMessageAppsRequest creates a request to invoke ListLiveMessageApps API
func CreateListLiveMessageAppsRequest() (request *ListLiveMessageAppsRequest) {
	request = &ListLiveMessageAppsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "ListLiveMessageApps", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListLiveMessageAppsResponse creates a response to parse from ListLiveMessageApps response
func CreateListLiveMessageAppsResponse() (response *ListLiveMessageAppsResponse) {
	response = &ListLiveMessageAppsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
