package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListEdgeTranscodeTemplate invokes the live.ListEdgeTranscodeTemplate API synchronously
func (client *Client) ListEdgeTranscodeTemplate(request *ListEdgeTranscodeTemplateRequest) (response *ListEdgeTranscodeTemplateResponse, err error) {
	response = CreateListEdgeTranscodeTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// ListEdgeTranscodeTemplateWithChan invokes the live.ListEdgeTranscodeTemplate API asynchronously
func (client *Client) ListEdgeTranscodeTemplateWithChan(request *ListEdgeTranscodeTemplateRequest) (<-chan *ListEdgeTranscodeTemplateResponse, <-chan error) {
	responseChan := make(chan *ListEdgeTranscodeTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListEdgeTranscodeTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListEdgeTranscodeTemplateWithCallback invokes the live.ListEdgeTranscodeTemplate API asynchronously
func (client *Client) ListEdgeTranscodeTemplateWithCallback(request *ListEdgeTranscodeTemplateRequest, callback func(response *ListEdgeTranscodeTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListEdgeTranscodeTemplateResponse
		var err error
		defer close(result)
		response, err = client.ListEdgeTranscodeTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListEdgeTranscodeTemplateRequest is the request struct for api ListEdgeTranscodeTemplate
type ListEdgeTranscodeTemplateRequest struct {
	*requests.RpcRequest
	Type       string           `position:"Query" name:"Type"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	Keyword    string           `position:"Query" name:"Keyword"`
	ClusterId  string           `position:"Query" name:"ClusterId"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
	PageNo     requests.Integer `position:"Query" name:"PageNo"`
	SortBy     string           `position:"Query" name:"SortBy"`
	VideoCodec string           `position:"Query" name:"VideoCodec"`
}

// ListEdgeTranscodeTemplateResponse is the response struct for api ListEdgeTranscodeTemplate
type ListEdgeTranscodeTemplateResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	TotalCount   int          `json:"TotalCount" xml:"TotalCount"`
	TemplateList TemplateList `json:"TemplateList" xml:"TemplateList"`
}

// CreateListEdgeTranscodeTemplateRequest creates a request to invoke ListEdgeTranscodeTemplate API
func CreateListEdgeTranscodeTemplateRequest() (request *ListEdgeTranscodeTemplateRequest) {
	request = &ListEdgeTranscodeTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "ListEdgeTranscodeTemplate", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListEdgeTranscodeTemplateResponse creates a response to parse from ListEdgeTranscodeTemplate response
func CreateListEdgeTranscodeTemplateResponse() (response *ListEdgeTranscodeTemplateResponse) {
	response = &ListEdgeTranscodeTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
