package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveInteractionMetricData invokes the live.DescribeLiveInteractionMetricData API synchronously
func (client *Client) DescribeLiveInteractionMetricData(request *DescribeLiveInteractionMetricDataRequest) (response *DescribeLiveInteractionMetricDataResponse, err error) {
	response = CreateDescribeLiveInteractionMetricDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveInteractionMetricDataWithChan invokes the live.DescribeLiveInteractionMetricData API asynchronously
func (client *Client) DescribeLiveInteractionMetricDataWithChan(request *DescribeLiveInteractionMetricDataRequest) (<-chan *DescribeLiveInteractionMetricDataResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveInteractionMetricDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveInteractionMetricData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveInteractionMetricDataWithCallback invokes the live.DescribeLiveInteractionMetricData API asynchronously
func (client *Client) DescribeLiveInteractionMetricDataWithCallback(request *DescribeLiveInteractionMetricDataRequest, callback func(response *DescribeLiveInteractionMetricDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveInteractionMetricDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveInteractionMetricData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveInteractionMetricDataRequest is the request struct for api DescribeLiveInteractionMetricData
type DescribeLiveInteractionMetricDataRequest struct {
	*requests.RpcRequest
	MetricType   string           `position:"Query" name:"MetricType"`
	EndTs        requests.Integer `position:"Query" name:"EndTs"`
	Os           string           `position:"Query" name:"Os"`
	BeginTs      requests.Integer `position:"Query" name:"BeginTs"`
	AppId        string           `position:"Query" name:"AppId"`
	TerminalType string           `position:"Query" name:"TerminalType"`
}

// DescribeLiveInteractionMetricDataResponse is the response struct for api DescribeLiveInteractionMetricData
type DescribeLiveInteractionMetricDataResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	SummaryData string `json:"SummaryData" xml:"SummaryData"`
	Nodes       []Data `json:"Nodes" xml:"Nodes"`
}

// CreateDescribeLiveInteractionMetricDataRequest creates a request to invoke DescribeLiveInteractionMetricData API
func CreateDescribeLiveInteractionMetricDataRequest() (request *DescribeLiveInteractionMetricDataRequest) {
	request = &DescribeLiveInteractionMetricDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveInteractionMetricData", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLiveInteractionMetricDataResponse creates a response to parse from DescribeLiveInteractionMetricData response
func CreateDescribeLiveInteractionMetricDataResponse() (response *DescribeLiveInteractionMetricDataResponse) {
	response = &DescribeLiveInteractionMetricDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
