package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveDomainPushTrafficData invokes the live.DescribeLiveDomainPushTrafficData API synchronously
func (client *Client) DescribeLiveDomainPushTrafficData(request *DescribeLiveDomainPushTrafficDataRequest) (response *DescribeLiveDomainPushTrafficDataResponse, err error) {
	response = CreateDescribeLiveDomainPushTrafficDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveDomainPushTrafficDataWithChan invokes the live.DescribeLiveDomainPushTrafficData API asynchronously
func (client *Client) DescribeLiveDomainPushTrafficDataWithChan(request *DescribeLiveDomainPushTrafficDataRequest) (<-chan *DescribeLiveDomainPushTrafficDataResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveDomainPushTrafficDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveDomainPushTrafficData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveDomainPushTrafficDataWithCallback invokes the live.DescribeLiveDomainPushTrafficData API asynchronously
func (client *Client) DescribeLiveDomainPushTrafficDataWithCallback(request *DescribeLiveDomainPushTrafficDataRequest, callback func(response *DescribeLiveDomainPushTrafficDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveDomainPushTrafficDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveDomainPushTrafficData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveDomainPushTrafficDataRequest is the request struct for api DescribeLiveDomainPushTrafficData
type DescribeLiveDomainPushTrafficDataRequest struct {
	*requests.RpcRequest
	LocationNameEn string           `position:"Query" name:"LocationNameEn"`
	StartTime      string           `position:"Query" name:"StartTime"`
	IspNameEn      string           `position:"Query" name:"IspNameEn"`
	DomainName     string           `position:"Query" name:"DomainName"`
	EndTime        string           `position:"Query" name:"EndTime"`
	OwnerId        requests.Integer `position:"Query" name:"OwnerId"`
	Interval       string           `position:"Query" name:"Interval"`
}

// DescribeLiveDomainPushTrafficDataResponse is the response struct for api DescribeLiveDomainPushTrafficData
type DescribeLiveDomainPushTrafficDataResponse struct {
	*responses.BaseResponse
	EndTime                string                                                    `json:"EndTime" xml:"EndTime"`
	StartTime              string                                                    `json:"StartTime" xml:"StartTime"`
	RequestId              string                                                    `json:"RequestId" xml:"RequestId"`
	DomainName             string                                                    `json:"DomainName" xml:"DomainName"`
	DataInterval           string                                                    `json:"DataInterval" xml:"DataInterval"`
	TrafficDataPerInterval TrafficDataPerIntervalInDescribeLiveDomainPushTrafficData `json:"TrafficDataPerInterval" xml:"TrafficDataPerInterval"`
}

// CreateDescribeLiveDomainPushTrafficDataRequest creates a request to invoke DescribeLiveDomainPushTrafficData API
func CreateDescribeLiveDomainPushTrafficDataRequest() (request *DescribeLiveDomainPushTrafficDataRequest) {
	request = &DescribeLiveDomainPushTrafficDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveDomainPushTrafficData", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLiveDomainPushTrafficDataResponse creates a response to parse from DescribeLiveDomainPushTrafficData response
func CreateDescribeLiveDomainPushTrafficDataResponse() (response *DescribeLiveDomainPushTrafficDataResponse) {
	response = &DescribeLiveDomainPushTrafficDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
