package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetOwnedJoinPermission invokes the linkwan.GetOwnedJoinPermission API synchronously
func (client *Client) GetOwnedJoinPermission(request *GetOwnedJoinPermissionRequest) (response *GetOwnedJoinPermissionResponse, err error) {
	response = CreateGetOwnedJoinPermissionResponse()
	err = client.DoAction(request, response)
	return
}

// GetOwnedJoinPermissionWithChan invokes the linkwan.GetOwnedJoinPermission API asynchronously
func (client *Client) GetOwnedJoinPermissionWithChan(request *GetOwnedJoinPermissionRequest) (<-chan *GetOwnedJoinPermissionResponse, <-chan error) {
	responseChan := make(chan *GetOwnedJoinPermissionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetOwnedJoinPermission(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetOwnedJoinPermissionWithCallback invokes the linkwan.GetOwnedJoinPermission API asynchronously
func (client *Client) GetOwnedJoinPermissionWithCallback(request *GetOwnedJoinPermissionRequest, callback func(response *GetOwnedJoinPermissionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetOwnedJoinPermissionResponse
		var err error
		defer close(result)
		response, err = client.GetOwnedJoinPermission(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetOwnedJoinPermissionRequest is the request struct for api GetOwnedJoinPermission
type GetOwnedJoinPermissionRequest struct {
	*requests.RpcRequest
	JoinPermissionId string `position:"Query" name:"JoinPermissionId"`
	IotInstanceId    string `position:"Query" name:"IotInstanceId"`
	ApiProduct       string `position:"Body" name:"ApiProduct"`
	ApiRevision      string `position:"Body" name:"ApiRevision"`
}

// GetOwnedJoinPermissionResponse is the response struct for api GetOwnedJoinPermission
type GetOwnedJoinPermissionResponse struct {
	*responses.BaseResponse
	RequestId string                       `json:"RequestId" xml:"RequestId"`
	Success   bool                         `json:"Success" xml:"Success"`
	Data      DataInGetOwnedJoinPermission `json:"Data" xml:"Data"`
}

// CreateGetOwnedJoinPermissionRequest creates a request to invoke GetOwnedJoinPermission API
func CreateGetOwnedJoinPermissionRequest() (request *GetOwnedJoinPermissionRequest) {
	request = &GetOwnedJoinPermissionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "GetOwnedJoinPermission", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetOwnedJoinPermissionResponse creates a response to parse from GetOwnedJoinPermission response
func CreateGetOwnedJoinPermissionResponse() (response *GetOwnedJoinPermissionResponse) {
	response = &GetOwnedJoinPermissionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
