package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CountGatewayTupleOrders invokes the linkwan.CountGatewayTupleOrders API synchronously
func (client *Client) CountGatewayTupleOrders(request *CountGatewayTupleOrdersRequest) (response *CountGatewayTupleOrdersResponse, err error) {
	response = CreateCountGatewayTupleOrdersResponse()
	err = client.DoAction(request, response)
	return
}

// CountGatewayTupleOrdersWithChan invokes the linkwan.CountGatewayTupleOrders API asynchronously
func (client *Client) CountGatewayTupleOrdersWithChan(request *CountGatewayTupleOrdersRequest) (<-chan *CountGatewayTupleOrdersResponse, <-chan error) {
	responseChan := make(chan *CountGatewayTupleOrdersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CountGatewayTupleOrders(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CountGatewayTupleOrdersWithCallback invokes the linkwan.CountGatewayTupleOrders API asynchronously
func (client *Client) CountGatewayTupleOrdersWithCallback(request *CountGatewayTupleOrdersRequest, callback func(response *CountGatewayTupleOrdersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CountGatewayTupleOrdersResponse
		var err error
		defer close(result)
		response, err = client.CountGatewayTupleOrders(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CountGatewayTupleOrdersRequest is the request struct for api CountGatewayTupleOrders
type CountGatewayTupleOrdersRequest struct {
	*requests.RpcRequest
	States      *[]string `position:"Query" name:"States"  type:"Repeated"`
	ApiProduct  string    `position:"Body" name:"ApiProduct"`
	ApiRevision string    `position:"Body" name:"ApiRevision"`
}

// CountGatewayTupleOrdersResponse is the response struct for api CountGatewayTupleOrders
type CountGatewayTupleOrdersResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      int64  `json:"Data" xml:"Data"`
}

// CreateCountGatewayTupleOrdersRequest creates a request to invoke CountGatewayTupleOrders API
func CreateCountGatewayTupleOrdersRequest() (request *CountGatewayTupleOrdersRequest) {
	request = &CountGatewayTupleOrdersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "CountGatewayTupleOrders", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCountGatewayTupleOrdersResponse creates a response to parse from CountGatewayTupleOrders response
func CreateCountGatewayTupleOrdersResponse() (response *CountGatewayTupleOrdersResponse) {
	response = &CountGatewayTupleOrdersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
