package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdatePictureSearchApp invokes the linkvisual.UpdatePictureSearchApp API synchronously
func (client *Client) UpdatePictureSearchApp(request *UpdatePictureSearchAppRequest) (response *UpdatePictureSearchAppResponse, err error) {
	response = CreateUpdatePictureSearchAppResponse()
	err = client.DoAction(request, response)
	return
}

// UpdatePictureSearchAppWithChan invokes the linkvisual.UpdatePictureSearchApp API asynchronously
func (client *Client) UpdatePictureSearchAppWithChan(request *UpdatePictureSearchAppRequest) (<-chan *UpdatePictureSearchAppResponse, <-chan error) {
	responseChan := make(chan *UpdatePictureSearchAppResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdatePictureSearchApp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdatePictureSearchAppWithCallback invokes the linkvisual.UpdatePictureSearchApp API asynchronously
func (client *Client) UpdatePictureSearchAppWithCallback(request *UpdatePictureSearchAppRequest, callback func(response *UpdatePictureSearchAppResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdatePictureSearchAppResponse
		var err error
		defer close(result)
		response, err = client.UpdatePictureSearchApp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdatePictureSearchAppRequest is the request struct for api UpdatePictureSearchApp
type UpdatePictureSearchAppRequest struct {
	*requests.RpcRequest
	Description   string `position:"Query" name:"Description"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	Name          string `position:"Query" name:"Name"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
	AppInstanceId string `position:"Query" name:"AppInstanceId"`
}

// UpdatePictureSearchAppResponse is the response struct for api UpdatePictureSearchApp
type UpdatePictureSearchAppResponse struct {
	*responses.BaseResponse
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreateUpdatePictureSearchAppRequest creates a request to invoke UpdatePictureSearchApp API
func CreateUpdatePictureSearchAppRequest() (request *UpdatePictureSearchAppRequest) {
	request = &UpdatePictureSearchAppRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "UpdatePictureSearchApp", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdatePictureSearchAppResponse creates a response to parse from UpdatePictureSearchApp response
func CreateUpdatePictureSearchAppResponse() (response *UpdatePictureSearchAppResponse) {
	response = &UpdatePictureSearchAppResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
