package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateTimeTemplate invokes the linkvisual.CreateTimeTemplate API synchronously
func (client *Client) CreateTimeTemplate(request *CreateTimeTemplateRequest) (response *CreateTimeTemplateResponse, err error) {
	response = CreateCreateTimeTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// CreateTimeTemplateWithChan invokes the linkvisual.CreateTimeTemplate API asynchronously
func (client *Client) CreateTimeTemplateWithChan(request *CreateTimeTemplateRequest) (<-chan *CreateTimeTemplateResponse, <-chan error) {
	responseChan := make(chan *CreateTimeTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateTimeTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateTimeTemplateWithCallback invokes the linkvisual.CreateTimeTemplate API asynchronously
func (client *Client) CreateTimeTemplateWithCallback(request *CreateTimeTemplateRequest, callback func(response *CreateTimeTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateTimeTemplateResponse
		var err error
		defer close(result)
		response, err = client.CreateTimeTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateTimeTemplateRequest is the request struct for api CreateTimeTemplate
type CreateTimeTemplateRequest struct {
	*requests.RpcRequest
	TimeSections *[]CreateTimeTemplateTimeSections `position:"Query" name:"TimeSections"  type:"Repeated"`
	AllDay       requests.Integer                  `position:"Query" name:"AllDay"`
	ApiProduct   string                            `position:"Body" name:"ApiProduct"`
	Name         string                            `position:"Query" name:"Name"`
	ApiRevision  string                            `position:"Body" name:"ApiRevision"`
}

// CreateTimeTemplateTimeSections is a repeated param struct in CreateTimeTemplateRequest
type CreateTimeTemplateTimeSections struct {
	DayOfWeek string `name:"DayOfWeek"`
	Begin     string `name:"Begin"`
	End       string `name:"End"`
}

// CreateTimeTemplateResponse is the response struct for api CreateTimeTemplate
type CreateTimeTemplateResponse struct {
	*responses.BaseResponse
	Code         string `json:"Code" xml:"Code"`
	Data         string `json:"Data" xml:"Data"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreateCreateTimeTemplateRequest creates a request to invoke CreateTimeTemplate API
func CreateCreateTimeTemplateRequest() (request *CreateTimeTemplateRequest) {
	request = &CreateTimeTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "CreateTimeTemplate", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateTimeTemplateResponse creates a response to parse from CreateTimeTemplate response
func CreateCreateTimeTemplateResponse() (response *CreateTimeTemplateResponse) {
	response = &CreateTimeTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
