package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddFaceDeviceGroup invokes the linkvisual.AddFaceDeviceGroup API synchronously
func (client *Client) AddFaceDeviceGroup(request *AddFaceDeviceGroupRequest) (response *AddFaceDeviceGroupResponse, err error) {
	response = CreateAddFaceDeviceGroupResponse()
	err = client.DoAction(request, response)
	return
}

// AddFaceDeviceGroupWithChan invokes the linkvisual.AddFaceDeviceGroup API asynchronously
func (client *Client) AddFaceDeviceGroupWithChan(request *AddFaceDeviceGroupRequest) (<-chan *AddFaceDeviceGroupResponse, <-chan error) {
	responseChan := make(chan *AddFaceDeviceGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddFaceDeviceGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddFaceDeviceGroupWithCallback invokes the linkvisual.AddFaceDeviceGroup API asynchronously
func (client *Client) AddFaceDeviceGroupWithCallback(request *AddFaceDeviceGroupRequest, callback func(response *AddFaceDeviceGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddFaceDeviceGroupResponse
		var err error
		defer close(result)
		response, err = client.AddFaceDeviceGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddFaceDeviceGroupRequest is the request struct for api AddFaceDeviceGroup
type AddFaceDeviceGroupRequest struct {
	*requests.RpcRequest
	IsolationId     string `position:"Query" name:"IsolationId"`
	ApiProduct      string `position:"Body" name:"ApiProduct"`
	ApiRevision     string `position:"Body" name:"ApiRevision"`
	DeviceGroupName string `position:"Query" name:"DeviceGroupName"`
}

// AddFaceDeviceGroupResponse is the response struct for api AddFaceDeviceGroup
type AddFaceDeviceGroupResponse struct {
	*responses.BaseResponse
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateAddFaceDeviceGroupRequest creates a request to invoke AddFaceDeviceGroup API
func CreateAddFaceDeviceGroupRequest() (request *AddFaceDeviceGroupRequest) {
	request = &AddFaceDeviceGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "AddFaceDeviceGroup", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddFaceDeviceGroupResponse creates a response to parse from AddFaceDeviceGroup response
func CreateAddFaceDeviceGroupResponse() (response *AddFaceDeviceGroupResponse) {
	response = &AddFaceDeviceGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
