package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateProductTags invokes the iot.UpdateProductTags API synchronously
func (client *Client) UpdateProductTags(request *UpdateProductTagsRequest) (response *UpdateProductTagsResponse, err error) {
	response = CreateUpdateProductTagsResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateProductTagsWithChan invokes the iot.UpdateProductTags API asynchronously
func (client *Client) UpdateProductTagsWithChan(request *UpdateProductTagsRequest) (<-chan *UpdateProductTagsResponse, <-chan error) {
	responseChan := make(chan *UpdateProductTagsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateProductTags(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateProductTagsWithCallback invokes the iot.UpdateProductTags API asynchronously
func (client *Client) UpdateProductTagsWithCallback(request *UpdateProductTagsRequest, callback func(response *UpdateProductTagsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateProductTagsResponse
		var err error
		defer close(result)
		response, err = client.UpdateProductTags(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateProductTagsRequest is the request struct for api UpdateProductTags
type UpdateProductTagsRequest struct {
	*requests.RpcRequest
	IotInstanceId string                         `position:"Query" name:"IotInstanceId"`
	ProductKey    string                         `position:"Query" name:"ProductKey"`
	ProductTag    *[]UpdateProductTagsProductTag `position:"Query" name:"ProductTag"  type:"Repeated"`
	ApiProduct    string                         `position:"Body" name:"ApiProduct"`
	ApiRevision   string                         `position:"Body" name:"ApiRevision"`
}

// UpdateProductTagsProductTag is a repeated param struct in UpdateProductTagsRequest
type UpdateProductTagsProductTag struct {
	TagValue string `name:"TagValue"`
	TagKey   string `name:"TagKey"`
}

// UpdateProductTagsResponse is the response struct for api UpdateProductTags
type UpdateProductTagsResponse struct {
	*responses.BaseResponse
	RequestId          string                                `json:"RequestId" xml:"RequestId"`
	Success            bool                                  `json:"Success" xml:"Success"`
	ErrorMessage       string                                `json:"ErrorMessage" xml:"ErrorMessage"`
	Code               string                                `json:"Code" xml:"Code"`
	InvalidProductTags InvalidProductTagsInUpdateProductTags `json:"InvalidProductTags" xml:"InvalidProductTags"`
}

// CreateUpdateProductTagsRequest creates a request to invoke UpdateProductTags API
func CreateUpdateProductTagsRequest() (request *UpdateProductTagsRequest) {
	request = &UpdateProductTagsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "UpdateProductTags", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateProductTagsResponse creates a response to parse from UpdateProductTags response
func CreateUpdateProductTagsResponse() (response *UpdateProductTagsResponse) {
	response = &UpdateProductTagsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
