package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RetrySoundCodeLabelBatch invokes the iot.RetrySoundCodeLabelBatch API synchronously
func (client *Client) RetrySoundCodeLabelBatch(request *RetrySoundCodeLabelBatchRequest) (response *RetrySoundCodeLabelBatchResponse, err error) {
	response = CreateRetrySoundCodeLabelBatchResponse()
	err = client.DoAction(request, response)
	return
}

// RetrySoundCodeLabelBatchWithChan invokes the iot.RetrySoundCodeLabelBatch API asynchronously
func (client *Client) RetrySoundCodeLabelBatchWithChan(request *RetrySoundCodeLabelBatchRequest) (<-chan *RetrySoundCodeLabelBatchResponse, <-chan error) {
	responseChan := make(chan *RetrySoundCodeLabelBatchResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RetrySoundCodeLabelBatch(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RetrySoundCodeLabelBatchWithCallback invokes the iot.RetrySoundCodeLabelBatch API asynchronously
func (client *Client) RetrySoundCodeLabelBatchWithCallback(request *RetrySoundCodeLabelBatchRequest, callback func(response *RetrySoundCodeLabelBatchResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RetrySoundCodeLabelBatchResponse
		var err error
		defer close(result)
		response, err = client.RetrySoundCodeLabelBatch(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RetrySoundCodeLabelBatchRequest is the request struct for api RetrySoundCodeLabelBatch
type RetrySoundCodeLabelBatchRequest struct {
	*requests.RpcRequest
	BatchCode     string `position:"Body" name:"BatchCode"`
	IotInstanceId string `position:"Body" name:"IotInstanceId"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
}

// RetrySoundCodeLabelBatchResponse is the response struct for api RetrySoundCodeLabelBatch
type RetrySoundCodeLabelBatchResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateRetrySoundCodeLabelBatchRequest creates a request to invoke RetrySoundCodeLabelBatch API
func CreateRetrySoundCodeLabelBatchRequest() (request *RetrySoundCodeLabelBatchRequest) {
	request = &RetrySoundCodeLabelBatchRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "RetrySoundCodeLabelBatch", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRetrySoundCodeLabelBatchResponse creates a response to parse from RetrySoundCodeLabelBatch response
func CreateRetrySoundCodeLabelBatchResponse() (response *RetrySoundCodeLabelBatchResponse) {
	response = &RetrySoundCodeLabelBatchResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
