package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PublishThingModelAsync invokes the iot.PublishThingModelAsync API synchronously
func (client *Client) PublishThingModelAsync(request *PublishThingModelAsyncRequest) (response *PublishThingModelAsyncResponse, err error) {
	response = CreatePublishThingModelAsyncResponse()
	err = client.DoAction(request, response)
	return
}

// PublishThingModelAsyncWithChan invokes the iot.PublishThingModelAsync API asynchronously
func (client *Client) PublishThingModelAsyncWithChan(request *PublishThingModelAsyncRequest) (<-chan *PublishThingModelAsyncResponse, <-chan error) {
	responseChan := make(chan *PublishThingModelAsyncResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PublishThingModelAsync(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PublishThingModelAsyncWithCallback invokes the iot.PublishThingModelAsync API asynchronously
func (client *Client) PublishThingModelAsyncWithCallback(request *PublishThingModelAsyncRequest, callback func(response *PublishThingModelAsyncResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PublishThingModelAsyncResponse
		var err error
		defer close(result)
		response, err = client.PublishThingModelAsync(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PublishThingModelAsyncRequest is the request struct for api PublishThingModelAsync
type PublishThingModelAsyncRequest struct {
	*requests.RpcRequest
	Description       string `position:"Query" name:"Description"`
	ThingModelVersion string `position:"Query" name:"ThingModelVersion"`
	IotInstanceId     string `position:"Query" name:"IotInstanceId"`
	ProductKey        string `position:"Query" name:"ProductKey"`
	ApiProduct        string `position:"Body" name:"ApiProduct"`
	ApiRevision       string `position:"Body" name:"ApiRevision"`
}

// PublishThingModelAsyncResponse is the response struct for api PublishThingModelAsync
type PublishThingModelAsyncResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Code         int    `json:"Code" xml:"Code"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreatePublishThingModelAsyncRequest creates a request to invoke PublishThingModelAsync API
func CreatePublishThingModelAsyncRequest() (request *PublishThingModelAsyncRequest) {
	request = &PublishThingModelAsyncRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "PublishThingModelAsync", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePublishThingModelAsyncResponse creates a response to parse from PublishThingModelAsync response
func CreatePublishThingModelAsyncResponse() (response *PublishThingModelAsyncResponse) {
	response = &PublishThingModelAsyncResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
