package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListProductByTags invokes the iot.ListProductByTags API synchronously
func (client *Client) ListProductByTags(request *ListProductByTagsRequest) (response *ListProductByTagsResponse, err error) {
	response = CreateListProductByTagsResponse()
	err = client.DoAction(request, response)
	return
}

// ListProductByTagsWithChan invokes the iot.ListProductByTags API asynchronously
func (client *Client) ListProductByTagsWithChan(request *ListProductByTagsRequest) (<-chan *ListProductByTagsResponse, <-chan error) {
	responseChan := make(chan *ListProductByTagsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListProductByTags(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListProductByTagsWithCallback invokes the iot.ListProductByTags API asynchronously
func (client *Client) ListProductByTagsWithCallback(request *ListProductByTagsRequest, callback func(response *ListProductByTagsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListProductByTagsResponse
		var err error
		defer close(result)
		response, err = client.ListProductByTags(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListProductByTagsRequest is the request struct for api ListProductByTags
type ListProductByTagsRequest struct {
	*requests.RpcRequest
	IotInstanceId string                         `position:"Query" name:"IotInstanceId"`
	PageSize      requests.Integer               `position:"Query" name:"PageSize"`
	CurrentPage   requests.Integer               `position:"Query" name:"CurrentPage"`
	ProductTag    *[]ListProductByTagsProductTag `position:"Query" name:"ProductTag"  type:"Repeated"`
	ApiProduct    string                         `position:"Body" name:"ApiProduct"`
	ApiRevision   string                         `position:"Body" name:"ApiRevision"`
}

// ListProductByTagsProductTag is a repeated param struct in ListProductByTagsRequest
type ListProductByTagsProductTag struct {
	TagValue string `name:"TagValue"`
	TagKey   string `name:"TagKey"`
}

// ListProductByTagsResponse is the response struct for api ListProductByTags
type ListProductByTagsResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	Success      bool         `json:"Success" xml:"Success"`
	ErrorMessage string       `json:"ErrorMessage" xml:"ErrorMessage"`
	Code         string       `json:"Code" xml:"Code"`
	ProductInfos ProductInfos `json:"ProductInfos" xml:"ProductInfos"`
}

// CreateListProductByTagsRequest creates a request to invoke ListProductByTags API
func CreateListProductByTagsRequest() (request *ListProductByTagsRequest) {
	request = &ListProductByTagsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "ListProductByTags", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListProductByTagsResponse creates a response to parse from ListProductByTags response
func CreateListProductByTagsResponse() (response *ListProductByTagsResponse) {
	response = &ListProductByTagsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
