package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateSoundCodeSchedule invokes the iot.CreateSoundCodeSchedule API synchronously
func (client *Client) CreateSoundCodeSchedule(request *CreateSoundCodeScheduleRequest) (response *CreateSoundCodeScheduleResponse, err error) {
	response = CreateCreateSoundCodeScheduleResponse()
	err = client.DoAction(request, response)
	return
}

// CreateSoundCodeScheduleWithChan invokes the iot.CreateSoundCodeSchedule API asynchronously
func (client *Client) CreateSoundCodeScheduleWithChan(request *CreateSoundCodeScheduleRequest) (<-chan *CreateSoundCodeScheduleResponse, <-chan error) {
	responseChan := make(chan *CreateSoundCodeScheduleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateSoundCodeSchedule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateSoundCodeScheduleWithCallback invokes the iot.CreateSoundCodeSchedule API asynchronously
func (client *Client) CreateSoundCodeScheduleWithCallback(request *CreateSoundCodeScheduleRequest, callback func(response *CreateSoundCodeScheduleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateSoundCodeScheduleResponse
		var err error
		defer close(result)
		response, err = client.CreateSoundCodeSchedule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateSoundCodeScheduleRequest is the request struct for api CreateSoundCodeSchedule
type CreateSoundCodeScheduleRequest struct {
	*requests.RpcRequest
	Description   string `position:"Body" name:"Description"`
	StartDate     string `position:"Body" name:"StartDate"`
	IotInstanceId string `position:"Body" name:"IotInstanceId"`
	EndDate       string `position:"Body" name:"EndDate"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	Name          string `position:"Body" name:"Name"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
	OpenType      string `position:"Body" name:"OpenType"`
}

// CreateSoundCodeScheduleResponse is the response struct for api CreateSoundCodeSchedule
type CreateSoundCodeScheduleResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         string `json:"Data" xml:"Data"`
}

// CreateCreateSoundCodeScheduleRequest creates a request to invoke CreateSoundCodeSchedule API
func CreateCreateSoundCodeScheduleRequest() (request *CreateSoundCodeScheduleRequest) {
	request = &CreateSoundCodeScheduleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "CreateSoundCodeSchedule", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateSoundCodeScheduleResponse creates a response to parse from CreateSoundCodeSchedule response
func CreateCreateSoundCodeScheduleResponse() (response *CreateSoundCodeScheduleResponse) {
	response = &CreateSoundCodeScheduleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
