package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateSoundCodeLabel invokes the iot.CreateSoundCodeLabel API synchronously
func (client *Client) CreateSoundCodeLabel(request *CreateSoundCodeLabelRequest) (response *CreateSoundCodeLabelResponse, err error) {
	response = CreateCreateSoundCodeLabelResponse()
	err = client.DoAction(request, response)
	return
}

// CreateSoundCodeLabelWithChan invokes the iot.CreateSoundCodeLabel API asynchronously
func (client *Client) CreateSoundCodeLabelWithChan(request *CreateSoundCodeLabelRequest) (<-chan *CreateSoundCodeLabelResponse, <-chan error) {
	responseChan := make(chan *CreateSoundCodeLabelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateSoundCodeLabel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateSoundCodeLabelWithCallback invokes the iot.CreateSoundCodeLabel API asynchronously
func (client *Client) CreateSoundCodeLabelWithCallback(request *CreateSoundCodeLabelRequest, callback func(response *CreateSoundCodeLabelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateSoundCodeLabelResponse
		var err error
		defer close(result)
		response, err = client.CreateSoundCodeLabel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateSoundCodeLabelRequest is the request struct for api CreateSoundCodeLabel
type CreateSoundCodeLabelRequest struct {
	*requests.RpcRequest
	ScheduleCode  string `position:"Body" name:"ScheduleCode"`
	IotInstanceId string `position:"Body" name:"IotInstanceId"`
	Label         string `position:"Body" name:"Label"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
}

// CreateSoundCodeLabelResponse is the response struct for api CreateSoundCodeLabel
type CreateSoundCodeLabelResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         string `json:"Data" xml:"Data"`
}

// CreateCreateSoundCodeLabelRequest creates a request to invoke CreateSoundCodeLabel API
func CreateCreateSoundCodeLabelRequest() (request *CreateSoundCodeLabelRequest) {
	request = &CreateSoundCodeLabelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "CreateSoundCodeLabel", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateSoundCodeLabelResponse creates a response to parse from CreateSoundCodeLabel response
func CreateCreateSoundCodeLabelResponse() (response *CreateSoundCodeLabelResponse) {
	response = &CreateSoundCodeLabelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
