package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BindSceneRuleToEdgeInstance invokes the iot.BindSceneRuleToEdgeInstance API synchronously
func (client *Client) BindSceneRuleToEdgeInstance(request *BindSceneRuleToEdgeInstanceRequest) (response *BindSceneRuleToEdgeInstanceResponse, err error) {
	response = CreateBindSceneRuleToEdgeInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// BindSceneRuleToEdgeInstanceWithChan invokes the iot.BindSceneRuleToEdgeInstance API asynchronously
func (client *Client) BindSceneRuleToEdgeInstanceWithChan(request *BindSceneRuleToEdgeInstanceRequest) (<-chan *BindSceneRuleToEdgeInstanceResponse, <-chan error) {
	responseChan := make(chan *BindSceneRuleToEdgeInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BindSceneRuleToEdgeInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BindSceneRuleToEdgeInstanceWithCallback invokes the iot.BindSceneRuleToEdgeInstance API asynchronously
func (client *Client) BindSceneRuleToEdgeInstanceWithCallback(request *BindSceneRuleToEdgeInstanceRequest, callback func(response *BindSceneRuleToEdgeInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BindSceneRuleToEdgeInstanceResponse
		var err error
		defer close(result)
		response, err = client.BindSceneRuleToEdgeInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BindSceneRuleToEdgeInstanceRequest is the request struct for api BindSceneRuleToEdgeInstance
type BindSceneRuleToEdgeInstanceRequest struct {
	*requests.RpcRequest
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	InstanceId    string `position:"Query" name:"InstanceId"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
	RuleId        string `position:"Query" name:"RuleId"`
}

// BindSceneRuleToEdgeInstanceResponse is the response struct for api BindSceneRuleToEdgeInstance
type BindSceneRuleToEdgeInstanceResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Code         string `json:"Code" xml:"Code"`
}

// CreateBindSceneRuleToEdgeInstanceRequest creates a request to invoke BindSceneRuleToEdgeInstance API
func CreateBindSceneRuleToEdgeInstanceRequest() (request *BindSceneRuleToEdgeInstanceRequest) {
	request = &BindSceneRuleToEdgeInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "BindSceneRuleToEdgeInstance", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBindSceneRuleToEdgeInstanceResponse creates a response to parse from BindSceneRuleToEdgeInstance response
func CreateBindSceneRuleToEdgeInstanceResponse() (response *BindSceneRuleToEdgeInstanceResponse) {
	response = &BindSceneRuleToEdgeInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
