package industry_brain

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// InvokeServiceAsync invokes the industry_brain.InvokeServiceAsync API synchronously
func (client *Client) InvokeServiceAsync(request *InvokeServiceAsyncRequest) (response *InvokeServiceAsyncResponse, err error) {
	response = CreateInvokeServiceAsyncResponse()
	err = client.DoAction(request, response)
	return
}

// InvokeServiceAsyncWithChan invokes the industry_brain.InvokeServiceAsync API asynchronously
func (client *Client) InvokeServiceAsyncWithChan(request *InvokeServiceAsyncRequest) (<-chan *InvokeServiceAsyncResponse, <-chan error) {
	responseChan := make(chan *InvokeServiceAsyncResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.InvokeServiceAsync(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// InvokeServiceAsyncWithCallback invokes the industry_brain.InvokeServiceAsync API asynchronously
func (client *Client) InvokeServiceAsyncWithCallback(request *InvokeServiceAsyncRequest, callback func(response *InvokeServiceAsyncResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *InvokeServiceAsyncResponse
		var err error
		defer close(result)
		response, err = client.InvokeServiceAsync(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// InvokeServiceAsyncRequest is the request struct for api InvokeServiceAsync
type InvokeServiceAsyncRequest struct {
	*requests.RpcRequest
	IsShowInput requests.Boolean `position:"Query" name:"IsShowInput"`
	ServiceId   string           `position:"Query" name:"ServiceId"`
	Params      string           `position:"Query" name:"Params"`
	RequestData string           `position:"Query" name:"RequestData"`
}

// InvokeServiceAsyncResponse is the response struct for api InvokeServiceAsync
type InvokeServiceAsyncResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateInvokeServiceAsyncRequest creates a request to invoke InvokeServiceAsync API
func CreateInvokeServiceAsyncRequest() (request *InvokeServiceAsyncRequest) {
	request = &InvokeServiceAsyncRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("industry-brain", "2019-06-29", "InvokeServiceAsync", "", "")
	request.Method = requests.POST
	return
}

// CreateInvokeServiceAsyncResponse creates a response to parse from InvokeServiceAsync response
func CreateInvokeServiceAsyncResponse() (response *InvokeServiceAsyncResponse) {
	response = &InvokeServiceAsyncResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
