package ims

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UnbindMFADevice invokes the ims.UnbindMFADevice API synchronously
func (client *Client) UnbindMFADevice(request *UnbindMFADeviceRequest) (response *UnbindMFADeviceResponse, err error) {
	response = CreateUnbindMFADeviceResponse()
	err = client.DoAction(request, response)
	return
}

// UnbindMFADeviceWithChan invokes the ims.UnbindMFADevice API asynchronously
func (client *Client) UnbindMFADeviceWithChan(request *UnbindMFADeviceRequest) (<-chan *UnbindMFADeviceResponse, <-chan error) {
	responseChan := make(chan *UnbindMFADeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UnbindMFADevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UnbindMFADeviceWithCallback invokes the ims.UnbindMFADevice API asynchronously
func (client *Client) UnbindMFADeviceWithCallback(request *UnbindMFADeviceRequest, callback func(response *UnbindMFADeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UnbindMFADeviceResponse
		var err error
		defer close(result)
		response, err = client.UnbindMFADevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UnbindMFADeviceRequest is the request struct for api UnbindMFADevice
type UnbindMFADeviceRequest struct {
	*requests.RpcRequest
	AkProxySuffix     string `position:"Query" name:"AkProxySuffix"`
	UserPrincipalName string `position:"Query" name:"UserPrincipalName"`
}

// UnbindMFADeviceResponse is the response struct for api UnbindMFADevice
type UnbindMFADeviceResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	MFADevice MFADevice `json:"MFADevice" xml:"MFADevice"`
}

// CreateUnbindMFADeviceRequest creates a request to invoke UnbindMFADevice API
func CreateUnbindMFADeviceRequest() (request *UnbindMFADeviceRequest) {
	request = &UnbindMFADeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ims", "2019-08-15", "UnbindMFADevice", "ims", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUnbindMFADeviceResponse creates a response to parse from UnbindMFADevice response
func CreateUnbindMFADeviceResponse() (response *UnbindMFADeviceResponse) {
	response = &UnbindMFADeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
