package imagerecog

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RecognizeVehicleType invokes the imagerecog.RecognizeVehicleType API synchronously
func (client *Client) RecognizeVehicleType(request *RecognizeVehicleTypeRequest) (response *RecognizeVehicleTypeResponse, err error) {
	response = CreateRecognizeVehicleTypeResponse()
	err = client.DoAction(request, response)
	return
}

// RecognizeVehicleTypeWithChan invokes the imagerecog.RecognizeVehicleType API asynchronously
func (client *Client) RecognizeVehicleTypeWithChan(request *RecognizeVehicleTypeRequest) (<-chan *RecognizeVehicleTypeResponse, <-chan error) {
	responseChan := make(chan *RecognizeVehicleTypeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RecognizeVehicleType(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RecognizeVehicleTypeWithCallback invokes the imagerecog.RecognizeVehicleType API asynchronously
func (client *Client) RecognizeVehicleTypeWithCallback(request *RecognizeVehicleTypeRequest, callback func(response *RecognizeVehicleTypeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RecognizeVehicleTypeResponse
		var err error
		defer close(result)
		response, err = client.RecognizeVehicleType(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RecognizeVehicleTypeRequest is the request struct for api RecognizeVehicleType
type RecognizeVehicleTypeRequest struct {
	*requests.RpcRequest
	FormatResultToJson requests.Boolean `position:"Query" name:"FormatResultToJson"`
	OssFile            string           `position:"Query" name:"OssFile"`
	RequestProxyBy     string           `position:"Query" name:"RequestProxyBy"`
	ImageURL           string           `position:"Body" name:"ImageURL"`
}

// RecognizeVehicleTypeResponse is the response struct for api RecognizeVehicleType
type RecognizeVehicleTypeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateRecognizeVehicleTypeRequest creates a request to invoke RecognizeVehicleType API
func CreateRecognizeVehicleTypeRequest() (request *RecognizeVehicleTypeRequest) {
	request = &RecognizeVehicleTypeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imagerecog", "2019-09-30", "RecognizeVehicleType", "", "")
	request.Method = requests.POST
	return
}

// CreateRecognizeVehicleTypeResponse creates a response to parse from RecognizeVehicleType response
func CreateRecognizeVehicleTypeResponse() (response *RecognizeVehicleTypeResponse) {
	response = &RecognizeVehicleTypeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
