package imageenhan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnhanceImageColor invokes the imageenhan.EnhanceImageColor API synchronously
func (client *Client) EnhanceImageColor(request *EnhanceImageColorRequest) (response *EnhanceImageColorResponse, err error) {
	response = CreateEnhanceImageColorResponse()
	err = client.DoAction(request, response)
	return
}

// EnhanceImageColorWithChan invokes the imageenhan.EnhanceImageColor API asynchronously
func (client *Client) EnhanceImageColorWithChan(request *EnhanceImageColorRequest) (<-chan *EnhanceImageColorResponse, <-chan error) {
	responseChan := make(chan *EnhanceImageColorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnhanceImageColor(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnhanceImageColorWithCallback invokes the imageenhan.EnhanceImageColor API asynchronously
func (client *Client) EnhanceImageColorWithCallback(request *EnhanceImageColorRequest, callback func(response *EnhanceImageColorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnhanceImageColorResponse
		var err error
		defer close(result)
		response, err = client.EnhanceImageColor(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnhanceImageColorRequest is the request struct for api EnhanceImageColor
type EnhanceImageColorRequest struct {
	*requests.RpcRequest
	Mode         string `position:"Body" name:"Mode"`
	OutputFormat string `position:"Body" name:"OutputFormat"`
	ImageURL     string `position:"Body" name:"ImageURL"`
}

// EnhanceImageColorResponse is the response struct for api EnhanceImageColor
type EnhanceImageColorResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateEnhanceImageColorRequest creates a request to invoke EnhanceImageColor API
func CreateEnhanceImageColorRequest() (request *EnhanceImageColorRequest) {
	request = &EnhanceImageColorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imageenhan", "2019-09-30", "EnhanceImageColor", "imageenhan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEnhanceImageColorResponse creates a response to parse from EnhanceImageColor response
func CreateEnhanceImageColorResponse() (response *EnhanceImageColorResponse) {
	response = &EnhanceImageColorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
