package idaas_doraemon

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListPwnedPasswords invokes the idaas_doraemon.ListPwnedPasswords API synchronously
func (client *Client) ListPwnedPasswords(request *ListPwnedPasswordsRequest) (response *ListPwnedPasswordsResponse, err error) {
	response = CreateListPwnedPasswordsResponse()
	err = client.DoAction(request, response)
	return
}

// ListPwnedPasswordsWithChan invokes the idaas_doraemon.ListPwnedPasswords API asynchronously
func (client *Client) ListPwnedPasswordsWithChan(request *ListPwnedPasswordsRequest) (<-chan *ListPwnedPasswordsResponse, <-chan error) {
	responseChan := make(chan *ListPwnedPasswordsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListPwnedPasswords(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListPwnedPasswordsWithCallback invokes the idaas_doraemon.ListPwnedPasswords API asynchronously
func (client *Client) ListPwnedPasswordsWithCallback(request *ListPwnedPasswordsRequest, callback func(response *ListPwnedPasswordsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListPwnedPasswordsResponse
		var err error
		defer close(result)
		response, err = client.ListPwnedPasswords(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListPwnedPasswordsRequest is the request struct for api ListPwnedPasswords
type ListPwnedPasswordsRequest struct {
	*requests.RpcRequest
	PrefixHexPasswordSha1Hash string `position:"Query" name:"PrefixHexPasswordSha1Hash"`
}

// ListPwnedPasswordsResponse is the response struct for api ListPwnedPasswords
type ListPwnedPasswordsResponse struct {
	*responses.BaseResponse
	RequestId          string  `json:"RequestId" xml:"RequestId"`
	PageNumber         int64   `json:"PageNumber" xml:"PageNumber"`
	TotalCount         int64   `json:"TotalCount" xml:"TotalCount"`
	PageSize           int64   `json:"PageSize" xml:"PageSize"`
	PwnedPasswordInfos []Items `json:"PwnedPasswordInfos" xml:"PwnedPasswordInfos"`
}

// CreateListPwnedPasswordsRequest creates a request to invoke ListPwnedPasswords API
func CreateListPwnedPasswordsRequest() (request *ListPwnedPasswordsRequest) {
	request = &ListPwnedPasswordsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("idaas-doraemon", "2021-05-20", "ListPwnedPasswords", "idaasauth", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListPwnedPasswordsResponse creates a response to parse from ListPwnedPasswords response
func CreateListPwnedPasswordsResponse() (response *ListPwnedPasswordsResponse) {
	response = &ListPwnedPasswordsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
