package hitsdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateInstanceSecurityGroups invokes the hitsdb.UpdateInstanceSecurityGroups API synchronously
func (client *Client) UpdateInstanceSecurityGroups(request *UpdateInstanceSecurityGroupsRequest) (response *UpdateInstanceSecurityGroupsResponse, err error) {
	response = CreateUpdateInstanceSecurityGroupsResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateInstanceSecurityGroupsWithChan invokes the hitsdb.UpdateInstanceSecurityGroups API asynchronously
func (client *Client) UpdateInstanceSecurityGroupsWithChan(request *UpdateInstanceSecurityGroupsRequest) (<-chan *UpdateInstanceSecurityGroupsResponse, <-chan error) {
	responseChan := make(chan *UpdateInstanceSecurityGroupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateInstanceSecurityGroups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateInstanceSecurityGroupsWithCallback invokes the hitsdb.UpdateInstanceSecurityGroups API asynchronously
func (client *Client) UpdateInstanceSecurityGroupsWithCallback(request *UpdateInstanceSecurityGroupsRequest, callback func(response *UpdateInstanceSecurityGroupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateInstanceSecurityGroupsResponse
		var err error
		defer close(result)
		response, err = client.UpdateInstanceSecurityGroups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateInstanceSecurityGroupsRequest is the request struct for api UpdateInstanceSecurityGroups
type UpdateInstanceSecurityGroupsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
	SecurityGroups       string           `position:"Query" name:"SecurityGroups"`
}

// UpdateInstanceSecurityGroupsResponse is the response struct for api UpdateInstanceSecurityGroups
type UpdateInstanceSecurityGroupsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateInstanceSecurityGroupsRequest creates a request to invoke UpdateInstanceSecurityGroups API
func CreateUpdateInstanceSecurityGroupsRequest() (request *UpdateInstanceSecurityGroupsRequest) {
	request = &UpdateInstanceSecurityGroupsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("hitsdb", "2020-06-15", "UpdateInstanceSecurityGroups", "hitsdb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateInstanceSecurityGroupsResponse creates a response to parse from UpdateInstanceSecurityGroups response
func CreateUpdateInstanceSecurityGroupsResponse() (response *UpdateInstanceSecurityGroupsResponse) {
	response = &UpdateInstanceSecurityGroupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
