package hbase

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateServerlessCluster invokes the hbase.CreateServerlessCluster API synchronously
func (client *Client) CreateServerlessCluster(request *CreateServerlessClusterRequest) (response *CreateServerlessClusterResponse, err error) {
	response = CreateCreateServerlessClusterResponse()
	err = client.DoAction(request, response)
	return
}

// CreateServerlessClusterWithChan invokes the hbase.CreateServerlessCluster API asynchronously
func (client *Client) CreateServerlessClusterWithChan(request *CreateServerlessClusterRequest) (<-chan *CreateServerlessClusterResponse, <-chan error) {
	responseChan := make(chan *CreateServerlessClusterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateServerlessCluster(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateServerlessClusterWithCallback invokes the hbase.CreateServerlessCluster API asynchronously
func (client *Client) CreateServerlessClusterWithCallback(request *CreateServerlessClusterRequest, callback func(response *CreateServerlessClusterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateServerlessClusterResponse
		var err error
		defer close(result)
		response, err = client.CreateServerlessCluster(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateServerlessClusterRequest is the request struct for api CreateServerlessCluster
type CreateServerlessClusterRequest struct {
	*requests.RpcRequest
	ClientType           string           `position:"Query" name:"ClientType"`
	ClusterName          string           `position:"Query" name:"ClusterName"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	EngineVersion        string           `position:"Query" name:"EngineVersion"`
	ResourceGroupId      string           `position:"Query" name:"ResourceGroupId"`
	Engine               string           `position:"Query" name:"Engine"`
	AutoRenewPeriod      requests.Integer `position:"Query" name:"AutoRenewPeriod"`
	Period               requests.Integer `position:"Query" name:"Period"`
	DiskType             string           `position:"Query" name:"DiskType"`
	VSwitchId            string           `position:"Query" name:"VSwitchId"`
	PeriodUnit           string           `position:"Query" name:"PeriodUnit"`
	ServerlessCapability requests.Integer `position:"Query" name:"ServerlessCapability"`
	VpcId                string           `position:"Query" name:"VpcId"`
	ZoneId               string           `position:"Query" name:"ZoneId"`
	ServerlessStorage    requests.Integer `position:"Query" name:"ServerlessStorage"`
	PayType              string           `position:"Query" name:"PayType"`
	ServerlessSpec       string           `position:"Query" name:"ServerlessSpec"`
}

// CreateServerlessClusterResponse is the response struct for api CreateServerlessCluster
type CreateServerlessClusterResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	ClusterId string `json:"ClusterId" xml:"ClusterId"`
	OrderId   string `json:"OrderId" xml:"OrderId"`
	PassWord  string `json:"PassWord" xml:"PassWord"`
}

// CreateCreateServerlessClusterRequest creates a request to invoke CreateServerlessCluster API
func CreateCreateServerlessClusterRequest() (request *CreateServerlessClusterRequest) {
	request = &CreateServerlessClusterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("HBase", "2019-01-01", "CreateServerlessCluster", "hbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateServerlessClusterResponse creates a response to parse from CreateServerlessCluster response
func CreateCreateServerlessClusterResponse() (response *CreateServerlessClusterResponse) {
	response = &CreateServerlessClusterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
