package gpdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListCollections invokes the gpdb.ListCollections API synchronously
func (client *Client) ListCollections(request *ListCollectionsRequest) (response *ListCollectionsResponse, err error) {
	response = CreateListCollectionsResponse()
	err = client.DoAction(request, response)
	return
}

// ListCollectionsWithChan invokes the gpdb.ListCollections API asynchronously
func (client *Client) ListCollectionsWithChan(request *ListCollectionsRequest) (<-chan *ListCollectionsResponse, <-chan error) {
	responseChan := make(chan *ListCollectionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListCollections(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListCollectionsWithCallback invokes the gpdb.ListCollections API asynchronously
func (client *Client) ListCollectionsWithCallback(request *ListCollectionsRequest, callback func(response *ListCollectionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListCollectionsResponse
		var err error
		defer close(result)
		response, err = client.ListCollections(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListCollectionsRequest is the request struct for api ListCollections
type ListCollectionsRequest struct {
	*requests.RpcRequest
	DBInstanceId      string           `position:"Query" name:"DBInstanceId"`
	OwnerId           requests.Integer `position:"Query" name:"OwnerId"`
	NamespacePassword string           `position:"Query" name:"NamespacePassword"`
	Namespace         string           `position:"Query" name:"Namespace"`
}

// ListCollectionsResponse is the response struct for api ListCollections
type ListCollectionsResponse struct {
	*responses.BaseResponse
	RequestId    string      `json:"RequestId" xml:"RequestId"`
	Count        int         `json:"Count" xml:"Count"`
	DBInstanceId string      `json:"DBInstanceId" xml:"DBInstanceId"`
	RegionId     string      `json:"RegionId" xml:"RegionId"`
	Namespace    string      `json:"Namespace" xml:"Namespace"`
	Message      string      `json:"Message" xml:"Message"`
	Status       string      `json:"Status" xml:"Status"`
	Collections  Collections `json:"Collections" xml:"Collections"`
}

// CreateListCollectionsRequest creates a request to invoke ListCollections API
func CreateListCollectionsRequest() (request *ListCollectionsRequest) {
	request = &ListCollectionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("gpdb", "2016-05-03", "ListCollections", "", "")
	request.Method = requests.POST
	return
}

// CreateListCollectionsResponse creates a response to parse from ListCollections response
func CreateListCollectionsResponse() (response *ListCollectionsResponse) {
	response = &ListCollectionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
