package governance

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListEnrolledAccounts invokes the governance.ListEnrolledAccounts API synchronously
func (client *Client) ListEnrolledAccounts(request *ListEnrolledAccountsRequest) (response *ListEnrolledAccountsResponse, err error) {
	response = CreateListEnrolledAccountsResponse()
	err = client.DoAction(request, response)
	return
}

// ListEnrolledAccountsWithChan invokes the governance.ListEnrolledAccounts API asynchronously
func (client *Client) ListEnrolledAccountsWithChan(request *ListEnrolledAccountsRequest) (<-chan *ListEnrolledAccountsResponse, <-chan error) {
	responseChan := make(chan *ListEnrolledAccountsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListEnrolledAccounts(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListEnrolledAccountsWithCallback invokes the governance.ListEnrolledAccounts API asynchronously
func (client *Client) ListEnrolledAccountsWithCallback(request *ListEnrolledAccountsRequest, callback func(response *ListEnrolledAccountsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListEnrolledAccountsResponse
		var err error
		defer close(result)
		response, err = client.ListEnrolledAccounts(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListEnrolledAccountsRequest is the request struct for api ListEnrolledAccounts
type ListEnrolledAccountsRequest struct {
	*requests.RpcRequest
	NextToken  string           `position:"Query" name:"NextToken"`
	MaxResults requests.Integer `position:"Query" name:"MaxResults"`
}

// ListEnrolledAccountsResponse is the response struct for api ListEnrolledAccounts
type ListEnrolledAccountsResponse struct {
	*responses.BaseResponse
	NextToken        string                 `json:"NextToken" xml:"NextToken"`
	RequestId        string                 `json:"RequestId" xml:"RequestId"`
	EnrolledAccounts []EnrolledAccountsItem `json:"EnrolledAccounts" xml:"EnrolledAccounts"`
}

// CreateListEnrolledAccountsRequest creates a request to invoke ListEnrolledAccounts API
func CreateListEnrolledAccountsRequest() (request *ListEnrolledAccountsRequest) {
	request = &ListEnrolledAccountsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("governance", "2021-01-20", "ListEnrolledAccounts", "governance", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListEnrolledAccountsResponse creates a response to parse from ListEnrolledAccounts response
func CreateListEnrolledAccountsResponse() (response *ListEnrolledAccountsResponse) {
	response = &ListEnrolledAccountsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
