package ga

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AttachLogStoreToEndpointGroup invokes the ga.AttachLogStoreToEndpointGroup API synchronously
func (client *Client) AttachLogStoreToEndpointGroup(request *AttachLogStoreToEndpointGroupRequest) (response *AttachLogStoreToEndpointGroupResponse, err error) {
	response = CreateAttachLogStoreToEndpointGroupResponse()
	err = client.DoAction(request, response)
	return
}

// AttachLogStoreToEndpointGroupWithChan invokes the ga.AttachLogStoreToEndpointGroup API asynchronously
func (client *Client) AttachLogStoreToEndpointGroupWithChan(request *AttachLogStoreToEndpointGroupRequest) (<-chan *AttachLogStoreToEndpointGroupResponse, <-chan error) {
	responseChan := make(chan *AttachLogStoreToEndpointGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AttachLogStoreToEndpointGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AttachLogStoreToEndpointGroupWithCallback invokes the ga.AttachLogStoreToEndpointGroup API asynchronously
func (client *Client) AttachLogStoreToEndpointGroupWithCallback(request *AttachLogStoreToEndpointGroupRequest, callback func(response *AttachLogStoreToEndpointGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AttachLogStoreToEndpointGroupResponse
		var err error
		defer close(result)
		response, err = client.AttachLogStoreToEndpointGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AttachLogStoreToEndpointGroupRequest is the request struct for api AttachLogStoreToEndpointGroup
type AttachLogStoreToEndpointGroupRequest struct {
	*requests.RpcRequest
	ClientToken      string    `position:"Query" name:"ClientToken"`
	SlsLogStoreName  string    `position:"Query" name:"SlsLogStoreName"`
	ListenerId       string    `position:"Query" name:"ListenerId"`
	EndpointGroupIds *[]string `position:"Query" name:"EndpointGroupIds"  type:"Repeated"`
	SlsProjectName   string    `position:"Query" name:"SlsProjectName"`
	SlsRegionId      string    `position:"Query" name:"SlsRegionId"`
	AcceleratorId    string    `position:"Query" name:"AcceleratorId"`
}

// AttachLogStoreToEndpointGroupResponse is the response struct for api AttachLogStoreToEndpointGroup
type AttachLogStoreToEndpointGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAttachLogStoreToEndpointGroupRequest creates a request to invoke AttachLogStoreToEndpointGroup API
func CreateAttachLogStoreToEndpointGroupRequest() (request *AttachLogStoreToEndpointGroupRequest) {
	request = &AttachLogStoreToEndpointGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ga", "2019-11-20", "AttachLogStoreToEndpointGroup", "gaplus", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAttachLogStoreToEndpointGroupResponse creates a response to parse from AttachLogStoreToEndpointGroup response
func CreateAttachLogStoreToEndpointGroupResponse() (response *AttachLogStoreToEndpointGroupResponse) {
	response = &AttachLogStoreToEndpointGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
