package foas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateQueue invokes the foas.UpdateQueue API synchronously
func (client *Client) UpdateQueue(request *UpdateQueueRequest) (response *UpdateQueueResponse, err error) {
	response = CreateUpdateQueueResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateQueueWithChan invokes the foas.UpdateQueue API asynchronously
func (client *Client) UpdateQueueWithChan(request *UpdateQueueRequest) (<-chan *UpdateQueueResponse, <-chan error) {
	responseChan := make(chan *UpdateQueueResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateQueue(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateQueueWithCallback invokes the foas.UpdateQueue API asynchronously
func (client *Client) UpdateQueueWithCallback(request *UpdateQueueRequest, callback func(response *UpdateQueueResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateQueueResponse
		var err error
		defer close(result)
		response, err = client.UpdateQueue(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateQueueRequest is the request struct for api UpdateQueue
type UpdateQueueRequest struct {
	*requests.RoaRequest
	QueueName string           `position:"Body" name:"queueName"`
	MaxMemMB  requests.Integer `position:"Body" name:"maxMemMB"`
	ClusterId string           `position:"Path" name:"clusterId"`
	Gpu       requests.Integer `position:"Body" name:"gpu"`
	MaxVcore  requests.Integer `position:"Body" name:"maxVcore"`
}

// UpdateQueueResponse is the response struct for api UpdateQueue
type UpdateQueueResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateQueueRequest creates a request to invoke UpdateQueue API
func CreateUpdateQueueRequest() (request *UpdateQueueRequest) {
	request = &UpdateQueueRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("foas", "2018-11-11", "UpdateQueue", "/api/v2/clusters/[clusterId]/queue", "foas", "openAPI")
	request.Method = requests.PUT
	return
}

// CreateUpdateQueueResponse creates a response to parse from UpdateQueue response
func CreateUpdateQueueResponse() (response *UpdateQueueResponse) {
	response = &UpdateQueueResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
