package foas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListProject invokes the foas.ListProject API synchronously
func (client *Client) ListProject(request *ListProjectRequest) (response *ListProjectResponse, err error) {
	response = CreateListProjectResponse()
	err = client.DoAction(request, response)
	return
}

// ListProjectWithChan invokes the foas.ListProject API asynchronously
func (client *Client) ListProjectWithChan(request *ListProjectRequest) (<-chan *ListProjectResponse, <-chan error) {
	responseChan := make(chan *ListProjectResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListProject(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListProjectWithCallback invokes the foas.ListProject API asynchronously
func (client *Client) ListProjectWithCallback(request *ListProjectRequest, callback func(response *ListProjectResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListProjectResponse
		var err error
		defer close(result)
		response, err = client.ListProject(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListProjectRequest is the request struct for api ListProject
type ListProjectRequest struct {
	*requests.RoaRequest
	Name       string           `position:"Query" name:"name"`
	PageSize   requests.Integer `position:"Query" name:"pageSize"`
	PageIndex  requests.Integer `position:"Query" name:"pageIndex"`
	ClusterId  string           `position:"Query" name:"clusterId"`
	Region     string           `position:"Query" name:"region"`
	DeployType string           `position:"Query" name:"deployType"`
}

// ListProjectResponse is the response struct for api ListProject
type ListProjectResponse struct {
	*responses.BaseResponse
	RequestId  string   `json:"RequestId" xml:"RequestId"`
	PageIndex  int      `json:"PageIndex" xml:"PageIndex"`
	PageSize   int      `json:"PageSize" xml:"PageSize"`
	TotalPage  int      `json:"TotalPage" xml:"TotalPage"`
	TotalCount int64    `json:"TotalCount" xml:"TotalCount"`
	Projects   Projects `json:"Projects" xml:"Projects"`
}

// CreateListProjectRequest creates a request to invoke ListProject API
func CreateListProjectRequest() (request *ListProjectRequest) {
	request = &ListProjectRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("foas", "2018-11-11", "ListProject", "/api/v2/projects", "foas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListProjectResponse creates a response to parse from ListProject response
func CreateListProjectResponse() (response *ListProjectResponse) {
	response = &ListProjectResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
