package facebody

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RetouchSkin invokes the facebody.RetouchSkin API synchronously
func (client *Client) RetouchSkin(request *RetouchSkinRequest) (response *RetouchSkinResponse, err error) {
	response = CreateRetouchSkinResponse()
	err = client.DoAction(request, response)
	return
}

// RetouchSkinWithChan invokes the facebody.RetouchSkin API asynchronously
func (client *Client) RetouchSkinWithChan(request *RetouchSkinRequest) (<-chan *RetouchSkinResponse, <-chan error) {
	responseChan := make(chan *RetouchSkinResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RetouchSkin(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RetouchSkinWithCallback invokes the facebody.RetouchSkin API asynchronously
func (client *Client) RetouchSkinWithCallback(request *RetouchSkinRequest, callback func(response *RetouchSkinResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RetouchSkinResponse
		var err error
		defer close(result)
		response, err = client.RetouchSkin(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RetouchSkinRequest is the request struct for api RetouchSkin
type RetouchSkinRequest struct {
	*requests.RpcRequest
	FormatResultToJson requests.Boolean `position:"Query" name:"FormatResultToJson"`
	RetouchDegree      requests.Float   `position:"Body" name:"RetouchDegree"`
	WhiteningDegree    requests.Float   `position:"Body" name:"WhiteningDegree"`
	OssFile            string           `position:"Query" name:"OssFile"`
	RequestProxyBy     string           `position:"Query" name:"RequestProxyBy"`
	ImageURL           string           `position:"Body" name:"ImageURL"`
}

// RetouchSkinResponse is the response struct for api RetouchSkin
type RetouchSkinResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateRetouchSkinRequest creates a request to invoke RetouchSkin API
func CreateRetouchSkinRequest() (request *RetouchSkinRequest) {
	request = &RetouchSkinRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("facebody", "2019-12-30", "RetouchSkin", "facebody", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRetouchSkinResponse creates a response to parse from RetouchSkin response
func CreateRetouchSkinResponse() (response *RetouchSkinResponse) {
	response = &RetouchSkinResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
