package facebody

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryFaceImageTemplate invokes the facebody.QueryFaceImageTemplate API synchronously
func (client *Client) QueryFaceImageTemplate(request *QueryFaceImageTemplateRequest) (response *QueryFaceImageTemplateResponse, err error) {
	response = CreateQueryFaceImageTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// QueryFaceImageTemplateWithChan invokes the facebody.QueryFaceImageTemplate API asynchronously
func (client *Client) QueryFaceImageTemplateWithChan(request *QueryFaceImageTemplateRequest) (<-chan *QueryFaceImageTemplateResponse, <-chan error) {
	responseChan := make(chan *QueryFaceImageTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryFaceImageTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryFaceImageTemplateWithCallback invokes the facebody.QueryFaceImageTemplate API asynchronously
func (client *Client) QueryFaceImageTemplateWithCallback(request *QueryFaceImageTemplateRequest, callback func(response *QueryFaceImageTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryFaceImageTemplateResponse
		var err error
		defer close(result)
		response, err = client.QueryFaceImageTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryFaceImageTemplateRequest is the request struct for api QueryFaceImageTemplate
type QueryFaceImageTemplateRequest struct {
	*requests.RpcRequest
	FormatResultToJson requests.Boolean `position:"Query" name:"FormatResultToJson"`
	UserId             string           `position:"Query" name:"UserId"`
	PageSize           requests.Integer `position:"Query" name:"PageSize"`
	OssFile            string           `position:"Query" name:"OssFile"`
	TemplateId         string           `position:"Query" name:"TemplateId"`
	RequestProxyBy     string           `position:"Query" name:"RequestProxyBy"`
	PageNo             requests.Integer `position:"Query" name:"PageNo"`
}

// QueryFaceImageTemplateResponse is the response struct for api QueryFaceImageTemplate
type QueryFaceImageTemplateResponse struct {
	*responses.BaseResponse
	RequestId string                       `json:"RequestId" xml:"RequestId"`
	Code      string                       `json:"Code" xml:"Code"`
	Message   string                       `json:"Message" xml:"Message"`
	Data      DataInQueryFaceImageTemplate `json:"Data" xml:"Data"`
}

// CreateQueryFaceImageTemplateRequest creates a request to invoke QueryFaceImageTemplate API
func CreateQueryFaceImageTemplateRequest() (request *QueryFaceImageTemplateRequest) {
	request = &QueryFaceImageTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("facebody", "2019-12-30", "QueryFaceImageTemplate", "facebody", "openAPI")
	request.Method = requests.GET
	return
}

// CreateQueryFaceImageTemplateResponse creates a response to parse from QueryFaceImageTemplate response
func CreateQueryFaceImageTemplateResponse() (response *QueryFaceImageTemplateResponse) {
	response = &QueryFaceImageTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
